#ifndef _RAM_FS_H_
#define _RAM_FS_H_

#include "mbed.h"

typedef struct _ram_fs_file_t {
    uint8_t fid;
    uint8_t* header;
    uint8_t* data;
    _ram_fs_file_t* next;
} ram_fs_file_t;

void ram_fs_new(uint8_t fid, uint8_t* header, uint8_t* data);
int ram_fs_delete(uint8_t fid);
int ram_fs_write(uint8_t fid, uint8_t* data, uint32_t offset, uint32_t length);
int ram_fs_read(uint8_t fid, uint8_t* data, uint32_t offset, uint32_t length);
void* ram_fs_get_header(uint8_t fid);
void* ram_fs_get_data(uint8_t fid);

#endif // _RAM_FS_H_
