#include "ram_fs.h"
#include "WizziDebug.h"

#if 0
    #define RAM_FS_PRINT(...)  PRINT(__VA_ARGS__)
#else
    #define RAM_FS_PRINT(...);
#endif

static ram_fs_file_t* g_fs = NULL;

static void ram_fs_update(ram_fs_file_t** file, ram_fs_file_t* file_new)
{
    if (*file == NULL)
    {
        // Append new file
        *file = file_new;
        return;
    }
    
    if ((*file)->fid == file_new->fid)
    {
        // Update existing file
        (*file)->header = file_new->header;
        (*file)->data = file_new->data;
        FREE(file_new);
        return;
    }
    
    ram_fs_update(&((*file)->next), file_new);
}

static ram_fs_file_t* ram_fs_get(ram_fs_file_t* file, uint8_t fid)
{
    if (file == NULL)
    {
        return NULL;
    }
    
    if (file->fid == fid)
    {
        return file;
    }
    
    return ram_fs_get(file->next, fid);
}

static int ram_fs_remove(ram_fs_file_t** file, uint8_t fid)
{
    if (*file == NULL)
    {
        // File does not exist
        return -1;
    }
    
    if ((*file)->fid == fid)
    {
        ram_fs_file_t* file_old = *file;
        *file = file_old->next;
        FREE(file_old);
        return 0;
    }
    
    return ram_fs_remove((ram_fs_file_t**)&((*file)->next), fid);
}

void ram_fs_new(uint8_t fid, uint8_t* header, uint8_t* data)
{
    RAM_FS_PRINT("NF(%d)\r\n", fid);
    
    ram_fs_file_t* file_new = (ram_fs_file_t*)MALLOC(sizeof(ram_fs_file_t));
    
    file_new->fid = fid;
    file_new->header = header;
    file_new->data = data;
    file_new->next = NULL;
    
    ram_fs_update(&g_fs, file_new);
}

int ram_fs_delete(uint8_t fid)
{
    RAM_FS_PRINT("DF(%d)\r\n", fid);
    return ram_fs_remove(&g_fs, fid);
}

int ram_fs_write(uint8_t fid, uint8_t* data, uint32_t offset, uint32_t length)
{
    ram_fs_file_t* file;
        
    RAM_FS_PRINT("WF(%d)\r\n", fid);
    
    // Retrieve pointer to file
    file = ram_fs_get(g_fs, fid);
        
    if (file == NULL)
    {
        return -1;
    }
    
    // Write the new data
    memcpy((void*)(file->data+offset), (void*)data, length);

    return 0;
}

int ram_fs_read(uint8_t fid, uint8_t* data, uint32_t offset, uint32_t length)
{
    ram_fs_file_t* file;
        
    RAM_FS_PRINT("RF(%d)\r\n", fid);
    
    // Retrieve pointer to file
    file = ram_fs_get(g_fs, fid);
        
    if (file == NULL)
    {
        return -1;
    }
    
    // Read data
    memcpy((void*)data, (void*)(file->data+offset), length);

    return 0;
}

void* ram_fs_get_header(uint8_t fid)
{
    ram_fs_file_t* file;
    
    RAM_FS_PRINT("RH(%d)\r\n", fid);
    
    // Retrieve pointer to file
    file = ram_fs_get(g_fs, fid);
        
    //ASSERT(file != NULL, "File %d does not exist!\r\n", fid);
    
    if (file == NULL)
    {
        return NULL;
    }
    else
    {
        // Return header pointer
        return file->header;
    }
}

void* ram_fs_get_data(uint8_t fid)
{
    ram_fs_file_t* file;
    
    RAM_FS_PRINT("RH(%d)\r\n", fid);
    
    // Retrieve pointer to file
    file = ram_fs_get(g_fs, fid);
        
    //ASSERT(file != NULL, "File %d does not exist!\r\n", fid);
    
    if (file == NULL)
    {
        return NULL;
    }
    else
    {
        // Return data pointer
        return file->data;
    }
}
