/// @copyright
/// ========================================================================={{{
/// Copyright (c) 2012-2013 WizziLab                                           /
/// All rights reserved                                                        /
///                                                                            /
/// IMPORTANT: This Software may not be modified, copied or distributed unless /
/// embedded on a WizziLab product. Other than for the foregoing purpose, this /
/// Software and/or its documentation may not be used, reproduced, copied,     /
/// prepared derivative works of, modified, performed, distributed, displayed  /
/// or sold for any purpose. For the sole purpose of embedding this Software   /
/// on a WizziLab product, copy, modification and distribution of this         /
/// Software is granted provided that the following conditions are respected:  /
///                                                                            /
/// *  Redistributions of source code must retain the above copyright notice,  /
///    this list of conditions and the following disclaimer                    /
///                                                                            /
/// *  Redistributions in binary form must reproduce the above copyright       /
///    notice, this list of conditions and the following disclaimer in the     /
///    documentation and/or other materials provided with the distribution.    /
///                                                                            /
/// *  The name of WizziLab can not be used to endorse or promote products     /
///    derived from this software without specific prior written permission.   /
///                                                                            /
/// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        /
/// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED  /
/// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR /
/// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR          /
/// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,      /
/// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,        /
/// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,            /
/// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     /
/// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    /
/// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         /
/// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               /
/// WIZZILAB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,       /
/// ENHANCEMENTS OR MODIFICATIONS.                                             /
///                                                                            /
/// Should you have any questions regarding your right to use this Software,   /
/// contact WizziLab at www.wizzilab.com.                                      /
///                                                                            /
/// =========================================================================}}}
/// @endcopyright

//  =======================================================================
/// @file           alp_helpers.h
/// @defgroup       ALP
/// @brief          ALP helpers functions
//  =======================================================================

#ifndef __ALP_HELPERS_H__
#define __ALP_HELPERS_H__

#include "hal_types.h"
//======================================================================
//======================================================================
//  ALP Helpers
//======================================================================
//======================================================================
typedef struct {
    u8*             data;   // data
    int             type;
    union
    {
        struct {
            u32             length;
            u32             offset;
            u8              fid;
        } f_data;
        struct {
            u32             length;
            u32             offset;
            u8              fid;
        } f_prop;
        struct {
            s8              code;
            u8              id; // Action ID
        } status;
        struct {
            u8              itf;
            s8              err;
        } istatus;
        struct {
            u32             length;
            u8              type;
        } itf;
        struct {
            u8              id;
            u8              eop;
            u8              err;
        } tag;
        struct {
            u32             per;
            u8              type;
            u8              ifid;
        } urc;
    } meta;
} alp_parsed_chunk_t;

//======================================================================
// alp_size
//----------------------------------------------------------------------
/// @brief Return payload length of most ALP operations
/// @param op       : ALP Action amongst alp_opcodes_t
/// @param offset   : Associated Offset if relevant
/// @param size     : Associated Size if relevant
/// @retval payload size in bytes
//======================================================================
public uint alp_size(u8 op, u32 offset, u32 length);

//======================================================================
// alp_encode_length
//----------------------------------------------------------------------
/// @brief Encodes an ALP length/offset field
/// @param p        : pointer to the payload buffer
/// @param len      : value to be encoded
/// @retval resulting payload size in bytes
//======================================================================
public u8 alp_encode_length(u8* p, u32 len);

//======================================================================
// alp_encode_length
//----------------------------------------------------------------------
/// @brief Decodes an ALP length/offset field
/// @param p        : pointer to the pointer to payload buffer
/// @param actp     : pointer to ALP's Action Protocol Substitution flag
///                   Result amongst alp_actp_substitution_mode_t
/// @retval decoded value
//======================================================================
public u32 alp_decode_length(u8** p, u8* actp);

//======================================================================
// alp_parse_chunk
//----------------------------------------------------------------------
/// @brief Parses an ALP response payload to a more generic
///        alp_parsed_chunk_t structure.
/// @param payload  : pointer to the pointer to payload buffer
/// @param resp     : pointer to alp_parsed_chunk_t structure
/// @retval number of parsed bytes
//======================================================================
public int alp_parse_chunk(u8** payload, alp_parsed_chunk_t* resp);



#endif // __ALP_HELPERS_H__
