/// ======================================================================
///
/// Copyright (C) 20XX WizziLab
/// All Rights Reserved
///
/// =======================================================================
///
/// @file           alp_fs.h
/// @brief          ALP File System definitions
/// =======================================================================

#ifndef __ALP_FS_H__
#define __ALP_FS_H__

#include "alp.h"

// =======================================================================
// alp_config_t
// -----------------------------------------------------------------------
/// ALP Configuration File structure
// =======================================================================
TYPEDEF_STRUCT_PACKED
{
    /// Retry-Policy Table
    alp_retry_policy_t  rpolt[ALP_RPOL_QTY];
    /// Number of URC that can be registered
    u8                  urc_qty;
    /// File ID of Root Key
    u8                  root_key_fid;
} alp_config_t;
#define FID_ALP_CFG_SIZE    sizeof(alp_config_t)

// Default Retry Policies table
#define ALP_DEFAULT_RPOL_TABLE { \
    /*     Background  Depth  Retries SlotMin SlotMax                            */ \
    ALP_RPOL(   0,      1,      0,      0,      0  ), /* ALP_RPOL_ONESHOT        */ \
    ALP_RPOL(   0,      1,      3,      1,      2  ), /* ALP_RPOL_ONESHOT_RETRY  */ \
    ALP_RPOL(   1,      4,      4,      1,      8  ), /* ALP_RPOL_FIFO_FAST      */ \
    ALP_RPOL(   1,      8,      8,      4,     32  ), /* ALP_RPOL_FIFO_SLOW      */ \
    ALP_RPOL(   1,      1,      4,      1,      8  ), /* ALP_RPOL_SINGLE_FAST    */ \
    ALP_RPOL(   1,      1,      8,      4,     32  ), /* ALP_RPOL_SINGLE_SLOW    */ \
    ALP_RPOL(   0,      1,      8,      1,     16  ), /* ALP_RPOL_ONESHOT_STICKY */ \
    ALP_RPOL(   0,      0,      0,      0,      0  ), /* ALP_RPOL_RFU_7          */ \
}

// Instanciate ALP Configuration File:
// _f   : ALP Config File ID
// _frk : Root Key File ID
// _r   : ALP "Retry Policies" Table
// _u   : Number of ALP URCs
#define ALP_FILE_INSTANCE(_f,_frk,_r,_u) \
alp_config_t f_alp_cfg FS_USER_SECTION = { \
    .rpolt          = _r, \
    .urc_qty        = _u, \
    .root_key_fid   = _frk}; \
FS_HDR_EEP(f_alp_cfg, _f, FID_ALP_CFG_SIZE, FS_READ_ONLY, FS_PERMANENT, 0, 0)

#define ALP_DEFAULT_FILE_INSTANCE(_f,_frk,_u) ALP_FILE_INSTANCE(_f,_frk,ALP_DEFAULT_RPOL_TABLE,_u)


#endif // __ALP_FS_H__
