/// @copyright
/// ========================================================================={{{
/// Copyright (c) 20XX                                                         /
/// All rights reserved                                                        /
///                                                                            /
/// IMPORTANT: This Software may not be modified, copied or distributed unless /
/// embedded on a WizziLab product. Other than for the foregoing purpose, this /
/// Software and/or its documentation may not be used, reproduced, copied,     /
/// prepared derivative works of, modified, performed, distributed, displayed  /
/// or sold for any purpose. For the sole purpose of embedding this Software   /
/// on a WizziLab product, copy, modification and distribution of this         /
/// Software is granted provided that the following conditions are respected:  /
///                                                                            /
/// *  Redistributions of source code must retain the above copyright notice,  /
///    this list of conditions and the following disclaimer                    /
///                                                                            /
/// *  Redistributions in binary form must reproduce the above copyright       /
///    notice, this list of conditions and the following disclaimer in the     /
///    documentation and/or other materials provided with the distribution.    /
///                                                                            /
/// *  The name of WizziLab can not be used to endorse or promote products     /
///    derived from this software without specific prior written permission.   /
///                                                                            /
/// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        /
/// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED  /
/// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR /
/// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR          /
/// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,      /
/// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,        /
/// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,            /
/// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     /
/// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    /
/// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         /
/// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               /
/// WIZZILAB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,       /
/// ENHANCEMENTS OR MODIFICATIONS.                                             /
///                                                                            /
/// Should you have any questions regarding your right to use this Software,   /
/// contact WizziLab at www.wizzilab.com.                                      /
///                                                                            /
/// =========================================================================}}}
/// @endcopyright

//  =======================================================================
/// @file           kal_crypto.h
/// @brief          KAL Crypto utilities
//  =======================================================================

#ifndef _KAL_CRYPTO_H_
#define _KAL_CRYPTO_H_

#include "hal_types.h"

// ======================================================================
//
//
//                        SHA-2 256 Tool-suite. 
//          (From Brad Conte's Licence-free implementation)
//
//
// ======================================================================

/// SHA256 digest output size in bytes
#define SHA256_BLOCK_SIZE 32 

//======================================================================
// kal_sha256_init
//----------------------------------------------------------------------
/// @brief Initialize an SHA Hash generation. To be called before any
///        other kal_sha256_update/final functions.
//======================================================================
public void kal_sha256_init(void);

//======================================================================
// kal_sha256_update
//----------------------------------------------------------------------
/// @brief Used to 'push' new data into the hash calculation.
/// @param data pointer to the (char) data stream to hash.
/// @param len data stream length in bytes
//======================================================================
public void kal_sha256_update(u8 data[], uint len);

//======================================================================
// kal_sha256_final
//----------------------------------------------------------------------
/// @brief To be called when all data has been pushed into the hash
///        generator. Finalize and outputs resulting SHA hash.
/// @param hash Pointer to the Output (char) buffer. Fills 32-bytes.
//======================================================================
public void kal_sha256_final(u8 hash[]);

#endif // _KAL_CRYPTO_H_

