/// @copyright
/// ========================================================================={{{
/// Copyright (c) 2012-2013 WizziLab                                           /
/// All rights reserved                                                        /
///                                                                            /
/// IMPORTANT: This Software may not be modified, copied or distributed unless /
/// embedded on a WizziLab product. Other than for the foregoing purpose, this /
/// Software and/or its documentation may not be used, reproduced, copied,     /
/// prepared derivative works of, modified, performed, distributed, displayed  /
/// or sold for any purpose. For the sole purpose of embedding this Software   /
/// on a WizziLab product, copy, modification and distribution of this         /
/// Software is granted provided that the following conditions are respected:  /
///                                                                            /
/// *  Redistributions of source code must retain the above copyright notice,  /
///    this list of conditions and the following disclaimer                    /
///                                                                            /
/// *  Redistributions in binary form must reproduce the above copyright       /
///    notice, this list of conditions and the following disclaimer in the     /
///    documentation and/or other materials provided with the distribution.    /
///                                                                            /
/// *  The name of WizziLab can not be used to endorse or promote products     /
///    derived from this software without specific prior written permission.   /
///                                                                            /
/// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        /
/// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED  /
/// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR /
/// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR          /
/// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,      /
/// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,        /
/// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,            /
/// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     /
/// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    /
/// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         /
/// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               /
/// WIZZILAB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,       /
/// ENHANCEMENTS OR MODIFICATIONS.                                             /
///                                                                            /
/// Should you have any questions regarding your right to use this Software,   /
/// contact WizziLab at www.wizzilab.com.                                      /
///                                                                            /
/// =========================================================================}}}
/// @endcopyright

//  =======================================================================
/// @file           alp.h
/// @brief          Wizzilab's specific ALP definitions
/// @defgroup       ALP
//  =======================================================================

#ifndef __ALP_H__
#define __ALP_H__

// D7A spec
#include "alp_spec.h"
// helpers
#include "alp_helpers.h"

// ALP_EVT_ITF_READY/CLOSED Event-param builder/splitter
#define ALP_ITF_EVP(itf,err)    (evt_param_t)(int)(((u8)err << 8)|((u8)itf))
#define ALP_ITF_EVP2ITF(evp)    ((evp) & 0xFF)
#define ALP_ITF_EVP2ERR(evp)    ((evp >> 8) & 0xFF)

// D7AActP Substitution modes:
// ----------------------------------------------------------------------
// MODE1: replace FID= actp.fid, offset=0,             length=(actp.fid).length
// MODE2: replace FID= actp.fid, offset=actp.offset,   length=actp.length
// ======================================================================
typedef enum {
    ACTP_SUBST_NONE = 0,
    ACTP_SUBST_MODE1,
    ACTP_SUBST_MODE2,
} alp_actp_substitution_mode_t;

typedef union {
    struct {
        u8 fid;
        u8 error;
    };
} alp_evt_done_evp_t;

typedef enum {
    ALP_ITF_FID_COM0,
    ALP_ITF_FID_COM1,
    ALP_ITF_FID_COM2,
    ALP_ITF_FID_COM_HACK_LIMIT = ALP_ITF_FID_COM2,
    ALP_ITF_FID_BLE,
} alp_itf_fixed_fids_t;

typedef enum {
    ALP_ROLE_ROOT       = 0xFF,
    ALP_ROLE_USER       = 0x38,
    ALP_ROLE_GUEST      = 0x07,
} alp_role_t;

typedef enum {
    ALP_RPOL_ONESHOT        = 0,
    ALP_RPOL_ONESHOT_RETRY  = 1,
    ALP_RPOL_FIFO_FAST      = 2,
    ALP_RPOL_FIFO_SLOW      = 3,
    ALP_RPOL_SINGLE_FAST    = 4,
    ALP_RPOL_SINGLE_SLOW    = 5,
    ALP_RPOL_ONESHOT_STICKY = 6,
    ALP_RPOL_RFU_7          = 7,
    ALP_RPOL_QTY,
} alp_rpol_t;

typedef enum {
    ALP_BOFF_NONE           = 0,
    ALP_BOFF_LINEAR         = 1,
    ALP_BOFF_EXP            = 2,

    ALP_BOFF_QTY
} alp_rpol_backoff_proc_t;


// Event parameter for ALP_EVT_URC
typedef union {
    struct {
        u8 type;
        u8 ifid;
        u8 value;
    };
} alp_urc_evp_t;

TYPEDEF_STRUCT_PACKED {
    u8 ifid;
    u8 report_freq;
} alp_urc_lqual_params_t;

TYPEDEF_STRUCT_PACKED {
    u8 ifid;
    u8 max_consecutive_errors;
} alp_urc_ldown_params_t;

// ALP D7 "Retry-policies" description
// ----------------------------------------------------------------------
// Retry-policies (also called QoS) are defining an application level
// set of parameters such as automatic retry in case of failure, termination
// messaging and other implementation dependent settings.
// ======================================================================
TYPEDEF_STRUCT_PACKED {
    /// Select between background of foreground tasks, 
    /// - if '1': Session fifo remains opened for further messaging
    /// - if '0': Session fifo is closed/released
    /// Replaces the "persistant flag" ("background" = "persistant").
    /// Note : In the D7A stack, the BG fifos have lower priority.
    /// This field could be extended to be a priority level
    u8 bg;
    /// Number of "pushed" messages that will be internally buffered
    /// until they are successfully sent. In case of overflow, the oldest
    /// message is lost.
    u8 depth;
    /// Maximum number of retry steps
    u8 retries;
    /// Minimum unit of time (in second) used for Backoff time calculation
    u8 slot_min;
    /// Maximum unit of time (in second) used for Backoff time calculation
    u8 slot_max;
} alp_retry_policy_t;

#define ALP_RPOL(_bg,_d,_r,_min,_max) \
        { \
            .bg         = (_bg), \
            .depth      = (_d), \
            .retries    = (_r), \
            .slot_min   = (_min), \
            .slot_max   = (_max), \
        }

// Basic public container for ALP payload.
typedef struct {
    u32             len;
    u8              d[1];
} alp_pub_payload_t;

typedef enum {
    /// Unsollicited message
    ALP_MSG_UNS,
    /// Deprecated
    ALP_MSG_ERR,
    /// Command message XXX deprecated BUT (mis)used in ALP Interfaces.
    ALP_MSG_CMD,
    /// Response message
    ALP_MSG_RES,
    /// Interface Termination message (used for TAG EOP handing)
    ALP_MSG_DONE,
} alp_msg_t;


//======================================================================
//======================================================================
//  D7A Interface
//======================================================================
//======================================================================

#include "d7a_1x.h"

//======================================================================
// alp_itf_d7a_cfg_t
//----------------------------------------------------------------------
// @brief ALP D7A interface configuration structure
//======================================================================
TYPEDEF_STRUCT_PACKED 
{
    u8 type;
    d7a_sp_cfg_t cfg;

} alp_itf_d7a_cfg_t;

#define ALP_D7A_ISTAT_NONE  0
#define ALP_D7A_ISTAT_UNS   (1<<0)
#define ALP_D7A_ISTAT_RESP  (1<<1)
#define ALP_D7A_ISTAT_EOP   (1<<2)

#endif // __ALP_H__