//  =======================================================================
/// @file           alp.h
/// @defgroup       ALP
//  =======================================================================

//======================================================================
//======================================================================
//  LWAN Interface
//======================================================================
//======================================================================

#ifndef __ALP_LWAN_H__
#define __ALP_LWAN_H__

#include "hal_types.h"

#include "alp.h"

#include "lora.h" // TODO cleanup lora headers

#define ALP_LWAN_ISTAT_NONE  0
#define ALP_LWAN_ISTAT_UNS   (1<<0)
#define ALP_LWAN_ISTAT_RESP  (1<<1)

typedef enum
{
    // LoRaWAN device class A
    // LoRaWAN Specification V1.0, chapter 3ff
    LWAN_CLASS_A,
    // LoRaWAN device class B
    // LoRaWAN Specification V1.0, chapter 8ff
    LWAN_CLASS_B,
    // LoRaWAN device class C
    // LoRaWAN Specification V1.0, chapter 17ff
    LWAN_CLASS_C,
}lwan_dev_class_t;

TYPEDEF_STRUCT_PACKED {
    u8 type;
    lwan_cfg_t cfg;
} lwan_itf_cfg_t;
#define FS_LWAN_ITF_SIZE    (sizeof(lwan_itf_cfg_t))
#endif // __ALP_LWAN_H__
