#ifndef __MODEM_REF_HELPER_H__
#define __MODEM_REF_HELPER_H__

#include "mbed.h"
#include "rtos.h"
#include "WizziDebug.h"
#include "WizziCom.h"

#include "hwcfg.h"
#include "ram_fs.h"

#include "alp.h"
#include "alp_fs.h"
#include "alp_helpers.h"
#include "alp_lwan.h"
#include "alp_spec.h"
#include "d7a_1x.h"
#include "d7a_1x_fs.h"
#include "kal_fs.h"
#include "kal_math.h"
#include "modem_ref.h"
#include "revision.h"


#define D7A_CTF_VAL(mant,exp)       ((uint8_t)(mant|(exp<<5)))
#define ALP_ITF_TYPE_D7A            0xD7
#define WM_FID_ALP_CFG              50

#define DEFAULT_ROOT_KEY            {206, 87, 116, 11, 4, 30, 202, 254, 206, 87, 116, 11, 4, 30, 202, 254}

#define MODEM_TIMEOUT               1000
#define MODEM_WAIT_RESP(_s)         do { if (!_s.try_acquire_for(MODEM_TIMEOUT)) { PRINT("Modem resp timeout line %d\n", __LINE__); } } while(0)

TYPEDEF_STRUCT_PACKED {
    uint8_t type;
    d7a_sp_cfg_t cfg;
} alp_d7a_itf_t;

void modem_helper_open(modem_callbacks_t* callbacks);
void modem_helper_close(void);
void modem_notify_host_rev(revision_t* data, alp_file_header_t* header, uint8_t* root_key);
void modem_update_file(uint8_t fid, alp_file_header_t* header, uint8_t* data);
void modem_print_error(uint8_t itf, int8_t error);

#define D7_ITF_SIZE(_itf) (1+my_alp_itf_d7a_cfg_size(&(_itf)->cfg))
int my_alp_itf_d7a_cfg_size(d7a_sp_cfg_t* cfg);

#endif