// -----------------------------------------------
// TARGET Options
// -----------------------------------------------

#if defined(TARGET_STM32L152RE)

    // -----------------------------------------------
    // Hardware configuration for sh2001 / sh2030
    // -----------------------------------------------
    #define MODEM_PIN_RX            (D10)
    #define MODEM_PIN_TX            (D2)
    #define MODEM_PIN_IRQ_IN        (D13)
    #define MODEM_PIN_IRQ_OUT       (D9)
    #define MODEM_PIN_RESET         (A3)
    //#define DEBUG_LED               (NC)
    #define DEBUG_BUTTON            (USER_BUTTON)
    #define SENSOR_I2C_SDA          (D14)
    #define SENSOR_I2C_SCL          (D15)
    
    #define __HW_VERSION__          0x15200000
 
#elif defined(TARGET_STM32L432KC)

    // -----------------------------------------------
    // Hardware configuration for sh2050
    // -----------------------------------------------
    #define MODEM_PIN_RX            (D5)
    #define MODEM_PIN_TX            (D4)
    #define MODEM_PIN_IRQ_IN        (D11)
    #define MODEM_PIN_IRQ_OUT       (D10)
    #define MODEM_PIN_RESET         (D12)
    #define DEBUG_LED               (D13) // LED1
    #define DEBUG_BUTTON            (D9)
    #define SENSOR_I2C_SDA          (D0)
    #define SENSOR_I2C_SCL          (D1)
    #define SENSOR_LIGHT_EN         (A1)
    #define SENSOR_LIGHT_MEAS       (A4)
    
    #define __HW_VERSION__          0x43200000
    
 #elif defined(TARGET_STM32L476RG)

    // -----------------------------------------------
    // Hardware configuration for Display demo only
    // -----------------------------------------------
    #define MODEM_PIN_RX            (PC_10)
    #define MODEM_PIN_TX            (PC_11)
    #define MODEM_PIN_IRQ_IN        (PC_12)
    #define MODEM_PIN_IRQ_OUT       (D9)
    #define MODEM_PIN_RESET         (A3)
    //#define DEBUG_LED               (NC)
    #define DEBUG_BUTTON            (USER_BUTTON)
    #define SENSOR_I2C_SDA          (D14)
    #define SENSOR_I2C_SCL          (D15)
    
    #define __HW_VERSION__          0x47600000
 
#else
    #error "Please choose or add the right platform."
#endif