#include "mbed.h"
#include "bin_SH2050.h"
#include "bootloader_SH2050.h"
#include "modem_d7a.h"

//------------------------------------------------------------------
// CUP Package files structure:
//   | SIZE |  ADDR  |      BINARY        |  PAD    | CRC  | Next Archive
//   |  4B  |   4B   |        XB          | 0-3 B   |  4B  | ...
//   |                                              |      | ...
//   |<------------------CRC----------------------->|      | ...
//   |<-----------------------SIZE------------------------>| ...
//
// Archive must be word-aligned
// Archives can be concatenated
// ADDR is the destination address of the installed archive
// SIZE accounts for whole archive (including itself)
// Binary size must be multiple of word (i.e pad=4)
// CRC calculated on whole archive (obviously excluding itself)
// Values (size,addr) are stored little-endian

//======================================================================
// cup_cfg_t
//----------------------------------------------------------------------
/// @brief  This is the structure of the CUP Config FILE.
///         This file _MUST_ always be located a the same place (EEPROM
///         Origin) as BOOT/CUP access it in a hardcoded way.
/// !! Do NOT touch this except if you're a CUP Master !!
//======================================================================
TYPEDEF_STRUCT_PACKED
{
    // The CUP Command
    uint16_t  cmd;
    // Number of Archives to be CUP'ed
    uint16_t  arch_nb;
    // This field has 2 meanings:
    // - when read-out it gives start address of CUP-Code file
    // - when written (for a CUP start) it gives the offset (in bytes) at
    //   which the first archive is stored in CUP-Code file
    uint32_t  src_offset;
    // CRC32 of the arch_nb concatenated archives starting at offset
    uint32_t  signature;
    // TODO: Deciphering key. For now CUP MAX size
    uint32_t  key;
    // Debug / Uart config
    uint32_t  dbg_cfg;
} cup_cfg_t;    

TYPEDEF_STRUCT_PACKED
{
    uint8_t* data;
    uint8_t cfg_fid;
    uint8_t code_fid;
    uint32_t code_size;
    uint32_t data_size;
    uint32_t local_mtu;
    uint32_t nb_archives;
    uint32_t signature;
    uint32_t mfg_id;
    uint32_t dev_id;
    uint32_t hw_id;
    uint8_t fw_major;
    uint8_t fw_minor;
    uint16_t fw_patch;
    uint32_t fw_hash;
    uint8_t target_fw_major;
    uint8_t target_fw_minor;
    uint8_t target_fw_patch;
    uint32_t target_fw_hash;
} cup_param_t;

void modem_cup_update(revision_t* rev);
    