#ifndef __MODEM_D7A_H__
#define __MODEM_D7A_H__

#include "mbed.h"
#include "rtos.h"
#include "WizziDebug.h"
#include "WizziCom.h"

#include "hwcfg.h"
#include "ram_fs.h"

#include "alp.h"
#include "alp_helpers.h"
#include "alp_lwan.h"
#include "alp_spec.h"
#include "d7a_1x.h"
#include "d7a_1x_fs.h"
#include "kal_fs.h"
#include "kal_math.h"
#include "modem_ref.h"
#include "revision.h"

#define DEFAULT_ROOT_KEY            {206, 87, 116, 11, 4, 30, 202, 254, 206, 87, 116, 11, 4, 30, 202, 254}

#define MODEM_TIMEOUT_LOCAL         1000
#define MODEM_TIMEOUT_DISTANT       60000
#define MODEM_WAIT_RESP(_s,_t)      modem_wait_resp(&(_s), (_t), (char*)__FUNCTION__, __LINE__)

TYPEDEF_STRUCT_PACKED {
    uint8_t type;
    d7a_sp_cfg_t cfg;
} alp_d7a_itf_t;

int modem_wait_resp(Semaphore* s, uint32_t timeout, char* function, uint32_t line);
int modem_open(modem_ref_callbacks_t* callbacks);
int modem_close(void);
void modem_print_error(uint8_t itf, int error);

int modem_raw_alp(alp_payload_t* alp, alp_payload_t** alp_rsp);
int modem_remote_raw_alp(void* itf, alp_payload_t* alp, alp_payload_t** alp_rsp);
int modem_read_file(uint8_t fid, void *data, uint32_t offset, uint32_t length);
int modem_remote_read_file(void* itf, void *istatus, uint8_t fid, void *data, uint32_t offset, uint32_t length);
int modem_write_file(uint8_t fid, void *data, uint32_t offset, uint32_t length);
int modem_remote_write_file(void* itf, void *istatus , uint8_t fid, void *data, uint32_t offset, uint32_t length);
int modem_flush_file(uint8_t fid);
int modem_declare_file(uint8_t fid, alp_file_header_t* header);
int modem_notify_file(uint8_t fid, uint32_t offset, uint32_t length);
int modem_d7a_enable_itf(void);
int modem_d7a_disable_itf(void);

int modem_lwan_open(void);
int modem_lwan_set_cfg(lwan_cfg_t* cfg);
int modem_lwan_set_nls(lwan_nls_t* nls);
int modem_lwan_send(alp_payload_t* alp);
int modem_lwan_get_status(lwan_status_t* status);



#define D7_ITF_SIZE(_itf) (1+my_alp_itf_d7a_cfg_size(&(_itf)->cfg))
int my_alp_itf_d7a_cfg_size(d7a_sp_cfg_t* cfg);

#endif