/// @copyright
/// ========================================================================={{{
/// Copyright (c) 2012-2013 WizziLab                                           /
/// All rights reserved                                                        /
///                                                                            /
/// IMPORTANT: This Software may not be modified, copied or distributed unless /
/// embedded on a WizziLab product. Other than for the foregoing purpose, this /
/// Software and/or its documentation may not be used, reproduced, copied,     /
/// prepared derivative works of, modified, performed, distributed, displayed  /
/// or sold for any purpose. For the sole purpose of embedding this Software   /
/// on a WizziLab product, copy, modification and distribution of this         /
/// Software is granted provided that the following conditions are respected:  /
///                                                                            /
/// *  Redistributions of source code must retain the above copyright notice,  /
///    this list of conditions and the following disclaimer                    /
///                                                                            /
/// *  Redistributions in binary form must reproduce the above copyright       /
///    notice, this list of conditions and the following disclaimer in the     /
///    documentation and/or other materials provided with the distribution.    /
///                                                                            /
/// *  The name of WizziLab can not be used to endorse or promote products     /
///    derived from this software without specific prior written permission.   /
///                                                                            /
/// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        /
/// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED  /
/// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR /
/// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR          /
/// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,      /
/// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,        /
/// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,            /
/// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     /
/// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    /
/// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         /
/// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               /
/// WIZZILAB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,       /
/// ENHANCEMENTS OR MODIFICATIONS.                                             /
///                                                                            /
/// Should you have any questions regarding your right to use this Software,   /
/// contact WizziLab at www.wizzilab.com.                                      /
///                                                                            /
/// =========================================================================}}}
/// @endcopyright

//  =======================================================================
/// @file           kal_fs.c
/// @brief          File-System header
//  =======================================================================

#ifndef __KAL_FS_H__
#define __KAL_FS_H__

// PROP Byte
#define FS_BFO_STORAGE_CLASS    0
#define FS_BFO_ACT_COND         4
#define FS_BFO_ACT_EN           7
#define FS_BFS_STORAGE_CLASS    2
#define FS_BFM_STORAGE_CLASS    0x3
#define FS_BFS_ACT_COND         3
#define FS_BFM_ACT_COND         0x7
#define FS_BFS_ACT_EN           1
#define FS_BFM_ACT_EN           0x1

// =======================================================================
// kal_fs_perm_t
// -----------------------------------------------------------------------
/// Bitfield structure of PERM
// =======================================================================
typedef union
{
    struct {
        /// Guest permissions
        u8 guest_x       : 1;
        u8 guest_w       : 1;
        u8 guest_r       : 1;
        /// User permissions
        u8 user_x        : 1;
        u8 user_w        : 1;
        u8 user_r        : 1;
        /// General permissions
        u8 writable      : 1;
        u8 readable      : 1;
    } bf;

    u8 byte;
} kal_fs_perm_t;

// PERM Byte
#define FS_BFO_GUEST_X          0
#define FS_BFO_GUEST_W          1
#define FS_BFO_GUEST_R          2
#define FS_BFO_USER_X           3
#define FS_BFO_USER_W           4
#define FS_BFO_USER_R           5
#define FS_BFO_WRITABLE         6
#define FS_BFO_READABLE         7
#define FS_BFS_GUEST_X          1
#define FS_BFS_GUEST_W          1
#define FS_BFS_GUEST_R          1
#define FS_BFS_USER_X           1
#define FS_BFS_USER_W           1
#define FS_BFS_USER_R           1
#define FS_BFS_WRITABLE         1
#define FS_BFS_READABLE         1

enum { TRANSIENT=0, VOLATILE, RESTORABLE, PERMANENT};

// "Piped" File: rd/wr are not stored but just sent on IF
#define FS_TRANSIENT         (TRANSIENT  << FS_BFO_STORAGE_CLASS)
// "RAM" File: rd/wr to a volatile buffer.
#define FS_VOLATILE          (VOLATILE   << FS_BFO_STORAGE_CLASS)
// "Mirrored" File: loaded from NVM, cached/used in RAM. Flushable to NVM.
#define FS_RESTORABLE        (RESTORABLE << FS_BFO_STORAGE_CLASS)
// "Normal" File: rd/wr from/to NVM
#define FS_PERMANENT         (PERMANENT  << FS_BFO_STORAGE_CLASS)
#define FS_ACT_COND(c)       ((c & 0x7) << FS_BFO_ACT_COND)
#define FS_ACT_EN            (1  << FS_BFO_ACT_EN)

// D7AactP Enabled File properties
#if 0 // Condition is not used (nor usable)
    #define FS_TRANSIENT_NOTIF(c) (FS_TRANSIENT  | FS_ACT_EN | FS_ACT_COND(c))
    #define FS_VOLATILE_NOTIF(c)  (FS_VOLATILE   | FS_ACT_EN | FS_ACT_COND(c))
    #define FS_RESTORABLE_NOTIF(c)(FS_RESTORABLE | FS_ACT_EN | FS_ACT_COND(c))
    #define FS_PERMANENT_NOTIF(c) (FS_PERMANENT  | FS_ACT_EN | FS_ACT_COND(c))
#else
    #define FS_TRANSIENT_NOTIF    (FS_TRANSIENT  | FS_ACT_EN)
    #define FS_VOLATILE_NOTIF     (FS_VOLATILE   | FS_ACT_EN)
    #define FS_RESTORABLE_NOTIF   (FS_RESTORABLE | FS_ACT_EN)
    #define FS_PERMANENT_NOTIF    (FS_PERMANENT  | FS_ACT_EN)
#endif

#define RWRWRW              0b11110110
#define RWRWR_              0b11110100
#define RWR_R_              0b11100100
#define R_R_R_              0b10100100
#define RWRW__              0b11110000
#define RW_W__              0b11010000
#define _W_W__              0b01010000
#define RWR___              0b11100000
#define RW____              0b11000000
#define R_R___              0b10100000
#define _W____              0b01000000
#define R_____              0b10000000

#define FS_GMASK_GUEST_X    FS_GUEST_X
#define FS_GMASK_GUEST_W    FS_GUEST_W
#define FS_GMASK_GUEST_R    FS_GUEST_R
#define FS_GMASK_USER_X     (FS_GUEST_X+FS_USER_X)
#define FS_GMASK_USER_W     (FS_GUEST_W+FS_USER_W)
#define FS_GMASK_USER_R     (FS_GUEST_R+FS_USER_R)

#endif // __KAL_FS_H__