/// @copyright
/// ========================================================================={{{
/// Copyright (c) 2012-2013 WizziLab                                           /
/// All rights reserved                                                        /
/// =========================================================================}}}
/// @endcopyright

//  =======================================================================
/// @file           cup.h
/// @brief          Code Upgrade _public header 
//  =======================================================================

#ifndef __CUP_H__
#define __CUP_H__


// Delay between a (Valid) START and actual reboot.
// Should let enough time for responding to the guy that started the CUP.
#define CUP_REBOOT_DELAY            600

// Delay for interface response.
// Should let enough time for responding to the guy that issued the command.
#define CUP_RESP_DELAY              100

// CUP Command Codes
#define CUP_CMD_UPGRADE_UPLOAD      0x10AD
#define CUP_CMD_UPGRADE_UPLOAD_ALT  0x10AC
#define CUP_CMD_UPGRADE_START       0xC0D5
#define CUP_CMD_UPGRADE_CONFIRMED   0xC0DC
#define CUP_CMD_UPGRADE_DONE        0xC0DD
#define CUP_CMD_UPGRADE_FILE_START  0xF105
#define CUP_CMD_UPGRADE_FILE_END    0xF10E
#define CUP_CMD_UPGRADE_FAIL        0xFA17
#define CUP_CMD_UPGRADE_FLASH_ERROR 0xFE44

// File Indexes
//#define CUP_CFG_FILE_ID             0x0
//#define CUP_CODE_FILE_ID            0x0

// STRUCTURES
//======================================================================

//======================================================================
// cup_cfg_t
//----------------------------------------------------------------------
/// @brief  This is the structure of the CUP Config FILE.
///         This file _MUST_ always be located a the same place (EEPROM
///         Origin) as BOOT/CUP access it in a hardcoded way.
/// !! Do NOT touch this except if you're a CUP Master !!
//======================================================================
TYPEDEF_STRUCT_PACKED
{
    // The CUP Command
    u16 cmd;
    // Number of Archives to be CUP'ed
    u16 arch_nb;
    // This field has 2 meanings:
    // - when read-out it gives start address of CUP-Code file
    // - when written (for a CUP start) it gives the offset (in bytes) at
    //   which the first archive is stored in CUP-Code file
    u32 src_offset;
    // CRC32 of the arch_nb concatenated archives starting at offset
    u32 signature;
    // TODO: Deciphering key
    u32 key;
    // Debug / Uart config
    u32 dbg_cfg;
} cup_cfg_t;

//======================================================================
// cup_cfg_bcast_header_t
//----------------------------------------------------------------------
/// @brief CUP broadcast configuration header (RAM file)
/// !! Do NOT touch this except if you're a CUP Master !!
//======================================================================
TYPEDEF_STRUCT_PACKED
{
    /// Bitmap start offset. Will differ from the
    /// CUP offset if the first chunk(s) are not received
    u32 start;
    /// Transfer length. Will differ from the CUP length 
    /// if the last chunk(s) are not received.
    u32 len;
    /// Transfer command / status
    u16 cmd;
    /// Chunk size used to generate the bitmap.
    /// It is assumed that all chunks except the last 
    /// have the same size
    u8  chunk;
    /// CUP timeout in seconds
    u8  to;
    /// new signature (command)
    u32 sig_new;
    /// current signature (status)
    u32 sig_curr;
    /// missed
    u16 missed;
    // RFU
    u8  rfu;
    /// signature status
    u8  crc_ok;

} cup_cfg_bcast_header_t;

//======================================================================
// cup_cfg_bcast_t
//----------------------------------------------------------------------
/// @brief CUP broadcast configuration (RAM file)
/// !! Do NOT touch this except if you're a CUP Master !!
//======================================================================
#define CUP_STATUS_BITMAP_LEN       (200)
TYPEDEF_STRUCT_PACKED
{
    /// CUP broadcast configuration header
    cup_cfg_bcast_header_t header;
    /// Bitmap buffer
    u8  bitmap[CUP_STATUS_BITMAP_LEN];

} cup_cfg_bcast_t;

#endif // __CUP_H__
/// @}
// vim:fdm=marker:fdc=2
