/// @copyright
/// ========================================================================={{{
/// Copyright (c) 2012-2013 WizziLab                                           /
/// All rights reserved                                                        /
/// =========================================================================}}}
/// @endcopyright

#ifndef __ALP_DBG_H__
#define __ALP_DBG_H__

#include "WizziDebug.h"

#define ALP_ASSERT(c,...)   ASSERT(c,__VA_ARGS__)

// ALP Trace Levels
#define L_ALP                (1 << 0)
#define L_ALP_HST            (1 << 1)
#define L_ALP_COM            (1 << 2)
#define L_ALP_D7A            (1 << 3)
#define L_ALP_LWAN           (1 << 4)
#define L_ALP_URC            (1 << 5)
#define L_ALP_BLE            (1 << 6)
#define L_ALP_DBG            (1 << 14)
#define L_ALP_ERR            (1 << 15)

// API level traces, should not be too verbose and can remain on release/prod build
// Still removable if needed
#ifndef __ALP_NO_PRINT__
    #define ALP_DPRINT(l, ...)   do {kal_dbg_cprintf(TLEV(TMOD_ALP, l), ##__VA_ARGS__);} while(0)
#else
    #define ALP_DPRINT(l, ...)
#endif

// Debug Oriented traces cherry-picked when debugging
// should never go into prod builds
#ifdef _BUILD_TYPE_DEBUG_
#if 0
    #define ALP_DBG_DPRINT(l,...) do{kal_dbg_cprintf(TLEV(TMOD_ALP,l),__VA_ARGS__);}while(0)
#endif
#endif // _BUILD_TYPE_DEBUG_

#ifndef ALP_DBG_DPRINT
    #define ALP_DBG_DPRINT(l,...) do {}while(0)
#endif


#endif // __ALP_DBG_H__
