/// @copyright
/// ========================================================================={{{
/// Copyright (c) 2012-2020 WizziLab                                           /
/// All rights reserved                                                        /
/// =========================================================================}}}
/// @endcopyright

//  =======================================================================
/// @file           lwan.h
/// @brief          LWAN Module headers
//  =======================================================================

#ifndef __LWAN_H__
#define __LWAN_H__

// =======================================================================
/// LoRa ISM Bands
// =======================================================================
typedef enum
{
    ISM_BAND_470,
    ISM_BAND_780,
    ISM_BAND_433,
    ISM_BAND_868,
    ISM_BAND_915,
    ISM_BAND_QTY,

} lwan_ism_band_t;

// =======================================================================
/// 
// =======================================================================
TYPEDEF_STRUCT_PACKED 
{
    // LoRaWAN device class
    u8 dev_class;
    // Activation state of adaptativeDatarate
    u8 adr_enable;
    // Uplink datarate, if adr_enable is off
    s8 tx_datarate;
    // ISM Band
    u8 ism_band;
    // Number of join attempts;
    u8 join_trials;
    // Rejoin period (hours)
    u8 rejoin_period;

} lwan_cfg_t;
#define FS_LWAN_CFG_SIZE    (sizeof(lwan_cfg_t))

// =======================================================================
/// 
// =======================================================================
TYPEDEF_STRUCT_PACKED 
{
    // Application identifier
    u8  app_id[8];
    // Application key
    u8  app_key[16];

} lwan_nls_t;
#define FS_LWAN_NLS_SIZE    (sizeof(lwan_nls_t))

// =======================================================================
/// 
// =======================================================================
#define FS_LWAN_STATUS_FREQS    8
TYPEDEF_STRUCT_PACKED 
{
    // Indicates if the MAC layer has already joined a network.
    bool        IsNetworkJoined;

    // Network ID ( 3 bytes )
    uint32_t    NetID;

    // ISM Band
    uint8_t     IsmBand;
    
    // Indicates if the node is connected to a _private or network
    bool        PublicNetwork;

    // ADR control status
    bool        AdrCtrlOn;

    // Enables/Disables duty cycle management (Test only)
    bool        DutyCycleOn;

    // Maximum duty cycle
    uint8_t     MaxDCycle;

    // frame counter. Each time a packet is sent the counter is incremented. Only the 16 LSB bits are sent
    uint32_t    UpLinkCounter;

    // frame counter. Each time a packet is received the counter is incremented. Only the 16 LSB bits are received
    uint32_t    DownLinkCounter;

    // Counts the number of missed ADR acknowledgements
    uint32_t    AdrAckCounter;

    // Channels TX power
    int8_t      TxPower;

    // Channels data rate
    int8_t      TxDr;

    // Datarate offset between uplink and downlink on first window
    uint8_t     Rx1DrOffset;

    // 2nd reception window frequency
    uint32_t    Rx2ChannelFreq;

    // 2nd reception window Datarate frequency
    uint8_t     Rx2ChannelDr;

     // Mask indicating which channels are enabled
    uint32_t    TxFreqs[FS_LWAN_STATUS_FREQS];    

} lwan_status_t;
#define FS_LWAN_STATUS_SIZE    (sizeof(lwan_status_t))

// =======================================================================
/// Classes
// =======================================================================
typedef enum
{
    // LoRaWAN device class A
    // LoRaWAN Specification V1.0, chapter 3ff
    LWAN_CLASS_A,
    // LoRaWAN device class B
    // LoRaWAN Specification V1.0, chapter 8ff
    LWAN_CLASS_B,
    // LoRaWAN device class C
    // LoRaWAN Specification V1.0, chapter 17ff
    LWAN_CLASS_C,

} lwan_dev_class_t;

#endif // __LWAN_H__
