#include "alp.h"

_private int alp_itf_d7a_ovld_size(u8* ovld)
{
    d7a_addressee_ctrl_t actl;
    actl.byte = ovld[0];
    int size = D7A_ADDR_LEN(actl);
    return size;
}

//======================================================================
// alp_itf_d7a_cfg_size
//----------------------------------------------------------------------
/// @brief  Get size of the D7A interface configuration
/// @param  cfg pointer to the configuration
/// @return int configuration size
//======================================================================
_public int alp_itf_d7a_cfg_size(u8* cfg)
{
    int size = sizeof(d7a_sp_cfg_t) - sizeof(d7a_addressee_t);
    size += alp_itf_d7a_ovld_size(&cfg[offsetof(d7a_sp_cfg_t,addressee)]);
    return size;
}
