/// @copyright
/// ========================================================================={{{
/// Copyright (c) 2012-2017 WizziLab                                           /
/// All rights reserved                                                        /
///                                                                            /
/// IMPORTANT: This Software may not be modified, copied or distributed unless /
/// embedded on a WizziLab product. Other than for the foregoing purpose, this /
/// Software and/or its documentation may not be used, reproduced, copied,     /
/// prepared derivative works of, modified, performed, distributed, displayed  /
/// or sold for any purpose. For the sole purpose of embedding this Software   /
/// on a WizziLab product, copy, modification and distribution of this         /
/// Software is granted provided that the following conditions are respected:  /
///                                                                            /
/// *  Redistributions of source code must retain the above copyright notice,  /
///    this list of conditions and the following disclaimer                    /
///                                                                            /
/// *  Redistributions in binary form must reproduce the above copyright       /
///    notice, this list of conditions and the following disclaimer in the     /
///    documentation and/or other materials provided with the distribution.    /
///                                                                            /
/// *  The name of WizziLab can not be used to endorse or promote products     /
///    derived from this software without specific prior written permission.   /
///                                                                            /
/// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        /
/// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED  /
/// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR /
/// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR          /
/// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,      /
/// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,        /
/// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,            /
/// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     /
/// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    /
/// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         /
/// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               /
/// WIZZILAB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,       /
/// ENHANCEMENTS OR MODIFICATIONS.                                             /
///                                                                            /
/// Should you have any questions regarding your right to use this Software,   /
/// contact WizziLab at www.wizzilab.com.                                      /
///                                                                            /
/// =========================================================================}}}
/// @endcopyright

#ifndef __REVISION_H__
#define __REVISION_H__

#include "hal_types.h"

//======================================================================
// Firmware version Structure
//
// Used within the revision structure
//======================================================================
TYPEDEF_STRUCT_PACKED
{
    u8  id;
    u8  major;
    u8  minor;
    u16 patch;
    u32 hash;
} fw_version_t;

//======================================================================
// Revision Structure
//
// Usage within D7B server:
// An XML describing the File system of a device is associated to a
// couple manufacturer_id/device_id (==Device).
// Different versions of the Device's XML can exist and can be mapped
// according to fw_version
//======================================================================
TYPEDEF_STRUCT_PACKED
{
    /// Manufacturer ID: provided by Wizzilab
    //  comes from: here
    u32 manufacturer_id;
    /// Device ID: Arbitrary number, at user/customer choice
    //  comes from: application
    u32 device_id;
    /// Hardware Board ID:
    //  comes from: board definition
    u32 hw_version;
    /// Firmware Version: made of
    ///  - major,minor and patch indexes : comes from versioning tool
    ///  - fw_id : "build-flavour" : comes from build setup
    ///  FW_ID | MAJOR | MINOR | PATCH | HASH |
    //     1B  |  1B   |  1B   |   2B  |  4B  |
    fw_version_t fw_version;
    /// Max CUP file size
    u32 cup_max_size;
} revision_t;

//======================================================================
// Identification / Revision numbers
//======================================================================
#define __MFGID_WIZZILAB__          0x01BC50C7
#define __MANUFACTURER_ID__         __MFGID_WIZZILAB__
#endif // __REVISION_H__


