/**
 ******************************************************************************
 * @file    LSM303C_ACC_driver.h
 * @author  MEMS Application Team
 * @version V1.1
 * @date    24-February-2016
 * @brief   LSM303C Accelerometer header driver file
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LSM303C_ACC_DRIVER__H
#define __LSM303C_ACC_DRIVER__H

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

/* Exported types ------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

//these could change accordingly with the architecture

#ifndef __ARCHDEP__TYPES
#define __ARCHDEP__TYPES

typedef unsigned char u8_t;
typedef unsigned short int u16_t;
typedef unsigned int u32_t;
typedef int i32_t;
typedef short int i16_t;
typedef signed char i8_t;

#endif /*__ARCHDEP__TYPES*/

/* Exported common structure --------------------------------------------------------*/

#ifndef __SHARED__TYPES
#define __SHARED__TYPES

typedef union{
    i16_t i16bit[3];
    u8_t u8bit[6];
} Type3Axis16bit_U; 

typedef union{
    i16_t i16bit;
    u8_t u8bit[2];
} Type1Axis16bit_U;

typedef union{
    i32_t i32bit;
    u8_t u8bit[4];
} Type1Axis32bit_U;

typedef enum {
  MEMS_SUCCESS = 0x01,
  MEMS_ERROR   = 0x00   
} status_t;

#endif /*__SHARED__TYPES*/

/* Exported macro ------------------------------------------------------------*/

/* Exported constants --------------------------------------------------------*/

/************** I2C Address *****************/

#define LSM303C_ACC_I2C_ADDRESS           0x3A
#define I_AM_LSM303C_ACC                  0x41

/* Acceleration Registers */
#define LSM303C_WHO_AM_I_REG_A            0x0F  /* device identification register */
#define LSM303C_ACT_THS_A                 0x1E
#define LSM303C_ACT_DUR_A                 0x1F
#define LSM303C_CTRL_REG1_A               0x20  /* Control register 1 acceleration */
#define LSM303C_CTRL_REG2_A               0x21  /* Control register 2 acceleration */
#define LSM303C_CTRL_REG3_A               0x22  /* Control register 3 acceleration */
#define LSM303C_CTRL_REG4_A               0x23  /* Control register 4 acceleration */
#define LSM303C_CTRL_REG5_A               0x24  /* Control register 5 acceleration */
#define LSM303C_CTRL_REG6_A               0x25  /* Control register 6 acceleration */
#define LSM303C_CTRL_REG7_A               0x26  /* Control register 6 acceleration */   
#define LSM303C_STATUS_REG_A              0x27  /* Status register acceleration */
#define LSM303C_OUT_X_L_A                 0x28  /* Output Register X acceleration */
#define LSM303C_OUT_X_H_A                 0x29  /* Output Register X acceleration */
#define LSM303C_OUT_Y_L_A                 0x2A  /* Output Register Y acceleration */
#define LSM303C_OUT_Y_H_A                 0x2B  /* Output Register Y acceleration */
#define LSM303C_OUT_Z_L_A                 0x2C  /* Output Register Z acceleration */
#define LSM303C_OUT_Z_H_A                 0x2D  /* Output Register Z acceleration */ 
#define LSM303C_FIFO_CTRL                 0x2E  /* Fifo control Register acceleration */
#define LSM303C_FIFO_SRC                  0x2F  /* Fifo src Register acceleration */

#define LSM303C_IG_CFG1_A                 0x30  /* Interrupt 1 configuration Register acceleration */
#define LSM303C_IG_SRC1_A                 0x31  /* Interrupt 1 source Register acceleration */
#define LSM303C_IG_THS_X1_A               0x32
#define LSM303C_IG_THS_Y1_A               0x33
#define LSM303C_IG_THS_Z1_A               0x34
   
#define LSM303C_IG_DUR1_A                 0x32
#define LSM303C_INT1_DURATION_A           0x33  /* Interrupt 1 DURATION register acceleration */

#define LSM303C_INT2_CFG_A                0x34  /* Interrupt 2 configuration Register acceleration */
#define LSM303C_INT2_SOURCE_A             0x35  /* Interrupt 2 source Register acceleration */
#define LSM303C_INT2_THS_A                0x36  /* Interrupt 2 Threshold register acceleration */
#define LSM303C_INT2_DURATION_A           0x37  /* Interrupt 2 DURATION register acceleration */

#define LSM303C_CLICK_CFG_A               0x38  /* Click configuration Register acceleration */
#define LSM303C_CLICK_SOURCE_A            0x39  /* Click 2 source Register acceleration */
#define LSM303C_CLICK_THS_A               0x3A  /* Click 2 Threshold register acceleration */

#define LSM303C_TIME_LIMIT_A              0x3B  /* Time Limit Register acceleration */
#define LSM303C_TIME_LATENCY_A            0x3C  /* Time Latency Register acceleration */
#define LSM303C_TIME_WINDOW_A             0x3D  /* Time window register acceleration */

/* Private Function Prototype -------------------------------------------------------*/

void LSM303C_ACC_SwapHighLowByte(u8_t *bufferToSwap, u8_t numberOfByte, u8_t dimension);

/* Public Function Prototypes ------------------------------------------------*/

status_t LSM303C_ACC_ReadReg( void *handle, u8_t Reg, u8_t* Data );
status_t LSM303C_ACC_WriteReg( void *handle, u8_t Reg, u8_t Data ); 


/*******************************************************************************
* Register      : WHO_AM_I
* Address       : 0X0F
* Bit Group Name: WHO_AM_I
* Permission    : RO
*******************************************************************************/
#define     LSM303C_ACC_WHO_AM_I_MASK     0xFF
#define     LSM303C_ACC_WHO_AM_I_POSITION     0
status_t LSM303C_ACC_R_WHO_AM_I(void *handle, u8_t *value);

/*******************************************************************************
* Register      : CTRL_REG1
* Address       : 0X20
* Bit Group Name: XEN
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_XEN_DISABLED       =0x00,
    LSM303C_ACC_XEN_ENABLED        =0x01,
} LSM303C_ACC_XEN_t;

#define     LSM303C_ACC_XEN_MASK      0x01
status_t  LSM303C_ACC_W_XEN(void *handle, LSM303C_ACC_XEN_t newValue);
status_t LSM303C_ACC_R_XEN(void *handle, LSM303C_ACC_XEN_t *value);

/*******************************************************************************
* Register      : CTRL_REG1
* Address       : 0X20
* Bit Group Name: YEN
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_YEN_DISABLED       =0x00,
    LSM303C_ACC_YEN_ENABLED        =0x02,
} LSM303C_ACC_YEN_t;

#define     LSM303C_ACC_YEN_MASK      0x02
status_t  LSM303C_ACC_W_YEN(void *handle, LSM303C_ACC_YEN_t newValue);
status_t LSM303C_ACC_R_YEN(void *handle, LSM303C_ACC_YEN_t *value);

/*******************************************************************************
* Register      : CTRL_REG1
* Address       : 0X20
* Bit Group Name: ZEN
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_ZEN_DISABLED       =0x00,
    LSM303C_ACC_ZEN_ENABLED        =0x04,
} LSM303C_ACC_ZEN_t;

#define     LSM303C_ACC_ZEN_MASK      0x04
status_t  LSM303C_ACC_W_ZEN(void *handle, LSM303C_ACC_ZEN_t newValue);
status_t LSM303C_ACC_R_ZEN(void *handle, LSM303C_ACC_ZEN_t *value);

/*******************************************************************************
* Register      : CTRL_REG1
* Address       : 0X20
* Bit Group Name: ODR
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_ODR_DO_PWR_DOWN     =0x00,
    LSM303C_ACC_ODR_DO_10Hz         =0x10,
    LSM303C_ACC_ODR_DO_50Hz         =0x20,
    LSM303C_ACC_ODR_DO_100Hz        =0x30,
    LSM303C_ACC_ODR_DO_200Hz        =0x40,
    LSM303C_ACC_ODR_DO_400Hz        =0x50,
    LSM303C_ACC_ODR_DO_800Hz        =0x60,
} LSM303C_ACC_ODR_t;

#define     LSM303C_ACC_ODR_MASK      0x70
status_t  LSM303C_ACC_W_ODR(void *handle, LSM303C_ACC_ODR_t newValue);
status_t LSM303C_ACC_R_ODR(void *handle, LSM303C_ACC_ODR_t *value);

/*******************************************************************************
* Register      : CTRL_REG2
* Address       : 0X21
* Bit Group Name: HPIS1
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_HPIS1_DISABLED         =0x00,
    LSM303C_ACC_HPIS1_ENABLED          =0x01,
} LSM303C_ACC_HPIS1_t;

#define     LSM303C_ACC_HPIS1_MASK    0x01
status_t  LSM303C_ACC_W_hpf_aoi_en_int1(void *handle, LSM303C_ACC_HPIS1_t newValue);
status_t LSM303C_ACC_R_hpf_aoi_en_int1(void *handle, LSM303C_ACC_HPIS1_t *value);

/*******************************************************************************
* Register      : CTRL_REG2
* Address       : 0X21
* Bit Group Name: HPIS2
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_HPIS2_DISABLED         =0x00,
    LSM303C_ACC_HPIS2_ENABLED          =0x02,
} LSM303C_ACC_HPIS2_t;

#define     LSM303C_ACC_HPIS2_MASK    0x02
status_t  LSM303C_ACC_W_hpf_aoi_en_int2(void *handle, LSM303C_ACC_HPIS2_t newValue);
status_t LSM303C_ACC_R_hpf_aoi_en_int2(void *handle, LSM303C_ACC_HPIS2_t *value);

/*******************************************************************************
* Register      : CTRL_REG2
* Address       : 0X21
* Bit Group Name: FDS
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_FDS_BYPASSED       =0x00,
    LSM303C_ACC_FDS_ENABLED        =0x04,
} LSM303C_ACC_FDS_t;

#define     LSM303C_ACC_FDS_MASK      0x04
status_t  LSM303C_ACC_W_Data_Filter(void *handle, LSM303C_ACC_FDS_t newValue);
status_t LSM303C_ACC_R_Data_Filter(void *handle, LSM303C_ACC_FDS_t *value);

/*******************************************************************************
* Register      : CTRL_REG2
* Address       : 0X21
* Bit Group Name: DFC
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_DFC_50      =0x00,
    LSM303C_ACC_DFC_100     =0x20,
    LSM303C_ACC_DFC_9       =0x40,
    LSM303C_ACC_DFC_400     =0x60,
} LSM303C_ACC_DFC_t;

#define     LSM303C_ACC_DFC_MASK     0x60
status_t  LSM303C_ACC_W_hpf_cutoff_freq(void *handle, LSM303C_ACC_DFC_t newValue);
status_t LSM303C_ACC_R_hpf_cutoff_freq(void *handle, LSM303C_ACC_DFC_t *value);

/*******************************************************************************
* Register      : CTRL_REG2
* Address       : 0X21
* Bit Group Name: HPM
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_HPM_NORMAL              =0x00,
    LSM303C_ACC_HPM_REFERENCE_SIGNAL    =0x08,
} LSM303C_ACC_HPM_t;

#define     LSM303C_ACC_HPM_MASK      0x18
status_t  LSM303C_ACC_W_hpf_mode(void *handle, LSM303C_ACC_HPM_t newValue);
status_t LSM303C_ACC_R_hpf_mode(void *handle, LSM303C_ACC_HPM_t *value);

/*******************************************************************************
* Register      : CTRL_REG1
* Address       : 0X23
* Bit Group Name: HR
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_HR_DISABLED        =0x00,
    LSM303C_ACC_HR_ENABLED         =0x80,
} LSM303C_ACC_HR_t;

#define     LSM303C_ACC_HR_MASK   0x80
status_t  LSM303C_ACC_W_HiRes(void *handle, LSM303C_ACC_HR_t newValue);
status_t LSM303C_ACC_R_HiRes(void *handle, LSM303C_ACC_HR_t *value);

/*******************************************************************************
* Register      : CTRL_REG4
* Address       : 0X23
* Bit Group Name: FS
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_FS_2G          =0x00,
    LSM303C_ACC_FS_4G          =0x20,
    LSM303C_ACC_FS_8G          =0x30,
} LSM303C_ACC_FS_t;

#define     LSM303C_ACC_FS_MASK   0x30
status_t  LSM303C_ACC_W_FullScale(void *handle, LSM303C_ACC_FS_t newValue);
status_t LSM303C_ACC_R_FullScale(void *handle, LSM303C_ACC_FS_t *value);

/*******************************************************************************
* Register      : CTRL_REG1
* Address       : 0X23
* Bit Group Name: BDU
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_BDU_DISABLED       =0x00,
    LSM303C_ACC_BDU_ENABLED        =0x08,
} LSM303C_ACC_BDU_t;

#define     LSM303C_ACC_BDU_MASK      0x08
status_t  LSM303C_ACC_W_BlockDataUpdate(void *handle, LSM303C_ACC_BDU_t newValue);
status_t LSM303C_ACC_R_BlockDataUpdate(void *handle, LSM303C_ACC_BDU_t *value);

/*******************************************************************************
* Register      : CTRL_REG3
* Address       : 0X24
* Bit Group Name: FIFO_EN
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_FIFO_EN_DISABLED       =0x00,
    LSM303C_ACC_FIFO_EN_ENABLED        =0x80,
} LSM303C_ACC_FIFO_EN_t;

#define     LSM303C_ACC_FIFO_EN_MASK      0x80
status_t  LSM303C_ACC_W_FIFO_EN(void *handle, LSM303C_ACC_FIFO_EN_t newValue);
status_t LSM303C_ACC_R_FIFO_EN(void *handle, LSM303C_ACC_FIFO_EN_t *value);


/*******************************************************************************
* Register      : CTRL_REG5
* Address       : 0X25
* Bit Group Name: H_LACTIVE
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_ACC_H_LACTIVE_ACTIVE_HI        =0x00,
    LSM303C_ACC_H_LACTIVE_ACTIVE_LO        =0x02,
} LSM303C_ACC_H_LACTIVE_t;

#define     LSM303C_ACC_H_LACTIVE_MASK    0x02
status_t  LSM303C_ACC_W_IntActive(void *handle, LSM303C_ACC_H_LACTIVE_t newValue);
status_t LSM303C_ACC_R_IntActive(void *handle, LSM303C_ACC_H_LACTIVE_t *value);

/*******************************************************************************
* Register      : STATUS_REG2
* Address       : 0X27
* Bit Group Name: XDA
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_ACC_XDA_NOT_AVAILABLE          =0x00,
    LSM303C_ACC_XDA_AVAILABLE          =0x01,
} LSM303C_ACC_XDA_t;

#define     LSM303C_ACC_XDA_MASK      0x01
status_t LSM303C_ACC_R_XDataAvail(void *handle, LSM303C_ACC_XDA_t *value);

/*******************************************************************************
* Register      : STATUS_REG2
* Address       : 0X27
* Bit Group Name: YDA
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_ACC_YDA_NOT_AVAILABLE          =0x00,
    LSM303C_ACC_YDA_AVAILABLE          =0x02,
} LSM303C_ACC_YDA_t;

#define     LSM303C_ACC_YDA_MASK      0x02
status_t LSM303C_ACC_R_YDataAvail(void *handle, LSM303C_ACC_YDA_t *value);

/*******************************************************************************
* Register      : STATUS_REG2
* Address       : 0X27
* Bit Group Name: ZDA
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_ACC_ZDA_NOT_AVAILABLE          =0x00,
    LSM303C_ACC_ZDA_AVAILABLE          =0x04,
} LSM303C_ACC_ZDA_t;

#define     LSM303C_ACC_ZDA_MASK      0x04
status_t LSM303C_ACC_R_ZDataAvail(void *handle, LSM303C_ACC_ZDA_t *value);

/*******************************************************************************
* Register      : STATUS_REG2
* Address       : 0X27
* Bit Group Name: ZYXDA
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_ACC_ZYXDA_NOT_AVAILABLE        =0x00,
    LSM303C_ACC_ZYXDA_AVAILABLE        =0x08,
} LSM303C_ACC_ZYXDA_t;

#define     LSM303C_ACC_ZYXDA_MASK    0x08
status_t LSM303C_ACC_R_XYZDataAvail(void *handle, LSM303C_ACC_ZYXDA_t *value);

/*******************************************************************************
* Register      : STATUS_REG2
* Address       : 0X27
* Bit Group Name: XOR
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_ACC_XOR_NO_OVERRUN         =0x00,
    LSM303C_ACC_XOR_OVERRUN        =0x10,
} LSM303C_ACC_XOR_t;

#define     LSM303C_ACC_XOR_MASK      0x10
status_t LSM303C_ACC_R_XDataOverrun(void *handle, LSM303C_ACC_XOR_t *value);

/*******************************************************************************
* Register      : STATUS_REG2
* Address       : 0X27
* Bit Group Name: YOR
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_ACC_YOR_NO_OVERRUN         =0x00,
    LSM303C_ACC_YOR_OVERRUN        =0x20,
} LSM303C_ACC_YOR_t;

#define     LSM303C_ACC_YOR_MASK      0x20
status_t LSM303C_ACC_R_YDataOverrun(void *handle, LSM303C_ACC_YOR_t *value);

/*******************************************************************************
* Register      : STATUS_REG2
* Address       : 0X27
* Bit Group Name: ZOR
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_ACC_ZOR_NO_OVERRUN         =0x00,
    LSM303C_ACC_ZOR_OVERRUN        =0x40,
} LSM303C_ACC_ZOR_t;

#define     LSM303C_ACC_ZOR_MASK      0x40
status_t LSM303C_ACC_R_ZDataOverrun(void *handle, LSM303C_ACC_ZOR_t *value);

/*******************************************************************************
* Register      : STATUS_REG2
* Address       : 0X27
* Bit Group Name: ZYXOR
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_ACC_ZYXOR_NO_OVERRUN       =0x00,
    LSM303C_ACC_ZYXOR_OVERRUN          =0x80,
} LSM303C_ACC_ZYXOR_t;

#define     LSM303C_ACC_ZYXOR_MASK    0x80
status_t LSM303C_ACC_R_XYZDataOverrun(void *handle, LSM303C_ACC_ZYXOR_t *value);

/*******************************************************************************
* Register      : <REGISTER_L> - <REGISTER_H>
* Output Type   : Acceleration
* Permission    : RO 
*******************************************************************************/
status_t LSM303C_ACC_Get_Raw_Acceleration(void *handle, u8_t *buff); 
status_t LSM303C_ACC_Get_Acceleration(void *handle, int *buff);

#ifdef __cplusplus
}
#endif

#endif
