/**
 ******************************************************************************
 * @file    LSM303C_MAG_driver.h
 * @author  MEMS Application Team
 * @version V1.1
 * @date    25-February-2016
 * @brief   LSM303C Magnetometer header driver file
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LSM303C_MAG_DRIVER__H
#define __LSM303C_MAG_DRIVER__H

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

/* Exported types ------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

//these could change accordingly with the architecture

#ifndef __ARCHDEP__TYPES
#define __ARCHDEP__TYPES

typedef unsigned char u8_t;
typedef unsigned short int u16_t;
typedef unsigned int u32_t;
typedef int i32_t;
typedef short int i16_t;
typedef signed char i8_t;

#endif /*__ARCHDEP__TYPES*/

/* Exported common structure --------------------------------------------------------*/

#ifndef __SHARED__TYPES
#define __SHARED__TYPES

typedef union{
    i16_t i16bit[3];
    u8_t u8bit[6];
} Type3Axis16bit_U; 

typedef union{
    i16_t i16bit;
    u8_t u8bit[2];
} Type1Axis16bit_U;

typedef union{
    i32_t i32bit;
    u8_t u8bit[4];
} Type1Axis32bit_U;

typedef enum {
  MEMS_SUCCESS = 0x01,
  MEMS_ERROR   = 0x00   
} status_t;

#endif /*__SHARED__TYPES*/

/* Exported macro ------------------------------------------------------------*/

/* Exported constants --------------------------------------------------------*/

/************** I2C Address *****************/

#define LSM303C_MAG_I2C_ADDRESS           0x3C
#define I_AM_LSM303C_MAG                  0x3D

/* Magnetic field Registers */
#define LSM303C_WHO_AM_I_REG_M            0x0F  /* device identification register */
#define LSM303C_CTRL_REG1_M               0x20  /* Magnetic control register 1 */
#define LSM303C_CTRL_REG2_M               0x21  /* Magnetic control register 2 */
#define LSM303C_CTRL_REG3_M               0x22  /* Magnetic control register 3 */
#define LSM303C_CTRL_REG4_M               0x23  /* Magnetic control register 4 */
#define LSM303C_CTRL_REG5_M               0x24  /* Magnetic control register 5 */   

#define LSM303C_STATUS_REG_M              0x27  /* Magnetic status register M  */

#define LSM303C_OUT_X_L_M                 0x28  /* Output Register X magnetic field */
#define LSM303C_OUT_X_H_M                 0x29  /* Output Register X magnetic field */
#define LSM303C_OUT_Y_L_M                 0x2A  /* Output Register Y magnetic field */
#define LSM303C_OUT_Y_H_M                 0x2B  /* Output Register Y magnetic field */
#define LSM303C_OUT_Z_L_M                 0x2C  /* Output Register Z magnetic field */ 
#define LSM303C_OUT_Z_H_M                 0x2D  /* Output Register Z magnetic field */

#define LSM303C_TEMP_OUT_L_M              0x2E  /* Temperature Register magnetic field */
#define LSM303C_TEMP_OUT_H_M              0x2F  /* Temperature Register magnetic field */

#define LSM303C_INT_CFG_M                 0x30  /* Axis interrupt configuration        */
#define LSM303C_INT_SRC_M                 0x31  /* Axis interrupt source               */
#define LSM303C_INT_THS_L_M               0x32  /* Interrupt threshold L               */
#define LSM303C_INT_THS_H_M               0x33  /* Interrupt threshold M               */ 

/* Private Function Prototype -------------------------------------------------------*/
 
void LSM303C_MAG_SwapHighLowByte(u8_t *bufferToSwap, u8_t numberOfByte, u8_t dimension);

/* Public Function Prototypes -------------------------------------------------------*/

status_t LSM303C_MAG_ReadReg( void *handle, u8_t Reg, u8_t* Data );
status_t LSM303C_MAG_WriteReg( void *handle, u8_t Reg, u8_t Data ); 

/*******************************************************************************
* Register      : WHO_AM_I_REG
* Address       : 0X4F
* Bit Group Name: WHO_AM_I
* Permission    : RO
*******************************************************************************/
#define     LSM303C_MAG_WHO_AM_I_MASK     0xFF
#define     LSM303C_MAG_WHO_AM_I_POSITION     0
status_t LSM303C_MAG_R_WHO_AM_I(void *handle, u8_t *value);

/*******************************************************************************
* Register      : CFG_REG_A
* Address       : 0X60
* Bit Group Name: MD
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_MAG_MD_CONTINUOS_MODE          =0x00,
    LSM303C_MAG_MD_SINGLE_MODE         =0x01,
    LSM303C_MAG_MD_IDLE1_MODE          =0x02,
    LSM303C_MAG_MD_IDLE2_MODE          =0x03,
} LSM303C_MAG_MD_t;

#define     LSM303C_MAG_MD_MASK   0x03
status_t  LSM303C_MAG_W_MD(void *handle, LSM303C_MAG_MD_t newValue);
status_t LSM303C_MAG_R_MD(void *handle, LSM303C_MAG_MD_t *value);

/*******************************************************************************
* Register      : CFG_REG_A
* Address       : 0X60
* Bit Group Name: ODR
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_MAG_ODR_0_625Hz      =0x00,
    LSM303C_MAG_ODR_1_25Hz       =0x04,
    LSM303C_MAG_ODR_2_5Hz        =0x08,
    LSM303C_MAG_ODR_5Hz          =0x0C,
    LSM303C_MAG_ODR_10Hz         =0x10,
    LSM303C_MAG_ODR_20Hz         =0x14,
    LSM303C_MAG_ODR_40Hz         =0x18,
    LSM303C_MAG_ODR_80Hz         =0x1C,
} LSM303C_MAG_ODR_t;

#define     LSM303C_MAG_ODR_MASK      0x1C
status_t  LSM303C_MAG_W_ODR(void *handle, LSM303C_MAG_ODR_t newValue);
status_t LSM303C_MAG_R_ODR(void *handle, LSM303C_MAG_ODR_t *value);

/*******************************************************************************
* Register      : CFG_REG_A
* Address       : 0X60
* Bit Group Name: LP
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_MAG_HR_MODE        =0x00,
    LSM303C_MAG_LP_MODE        =0x20,
} LSM303C_MAG_LP_t;

#define     LSM303C_MAG_LP_MASK   0x20
status_t  LSM303C_MAG_W_LP(void *handle, LSM303C_MAG_LP_t newValue);
status_t LSM303C_MAG_R_LP(void *handle, LSM303C_MAG_LP_t *value);

/*******************************************************************************
* Register      : CFG_REG_A
* Address       : 0X60
* Bit Group Name: SOFT_RST
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_MAG_SOFT_RST_DISABLED          =0x00,
    LSM303C_MAG_SOFT_RST_ENABLED       =0x04,
} LSM303C_MAG_SOFT_RST_t;

#define     LSM303C_MAG_SOFT_RST_MASK     0x04
status_t  LSM303C_MAG_W_SOFT_RST(void *handle, LSM303C_MAG_SOFT_RST_t newValue);
status_t LSM303C_MAG_R_SOFT_RST(void *handle, LSM303C_MAG_SOFT_RST_t *value);

/*******************************************************************************
* Register      : CFG_REG_C
* Address       : 0X62
* Bit Group Name: ST
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_MAG_ST_DISABLED        =0x00,
    LSM303C_MAG_ST_ENABLED         =0x01,
} LSM303C_MAG_ST_t;

#define     LSM303C_MAG_ST_MASK   0x01
status_t  LSM303C_MAG_W_ST(void *handle, LSM303C_MAG_ST_t newValue);
status_t LSM303C_MAG_R_ST(void *handle, LSM303C_MAG_ST_t *value);

/*******************************************************************************
* Register      : CFG_REG_C
* Address       : 0X62
* Bit Group Name: BLE
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_MAG_BLE_DISABLED       =0x00,
    LSM303C_MAG_BLE_ENABLED        =0x02,
} LSM303C_MAG_BLE_t;

#define     LSM303C_MAG_BLE_MASK      0x02
status_t  LSM303C_MAG_W_BLE(void *handle, LSM303C_MAG_BLE_t newValue);
status_t LSM303C_MAG_R_BLE(void *handle, LSM303C_MAG_BLE_t *value);

/*******************************************************************************
* Register      : CFG_REG_C
* Address       : 0X62
* Bit Group Name: BDU
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_MAG_BDU_DISABLED       =0x00,
    LSM303C_MAG_BDU_ENABLED        =0x40,
} LSM303C_MAG_BDU_t;

#define     LSM303C_MAG_BDU_MASK      0x40
status_t  LSM303C_MAG_W_BDU(void *handle, LSM303C_MAG_BDU_t newValue);
status_t LSM303C_MAG_R_BDU(void *handle, LSM303C_MAG_BDU_t *value);

/*******************************************************************************
* Register      : CFG_REG_C
* Address       : 0X62
* Bit Group Name: I2C_DIS
* Permission    : RW
*******************************************************************************/
typedef enum {
    LSM303C_MAG_I2C_ENABLED        =0x00,
    LSM303C_MAG_I2C_DISABLED       =0x80,
} LSM303C_MAG_I2C_DIS_t;

#define     LSM303C_MAG_I2C_DIS_MASK      0x80
status_t  LSM303C_MAG_W_I2C_DIS(void *handle, LSM303C_MAG_I2C_DIS_t newValue);
status_t LSM303C_MAG_R_I2C_DIS(void *handle, LSM303C_MAG_I2C_DIS_t *value);

/*******************************************************************************
* Register      : STATUS_REG
* Address       : 0X67
* Bit Group Name: XDA
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_MAG_XDA_EV_OFF         =0x00,
    LSM303C_MAG_XDA_EV_ON          =0x01,
} LSM303C_MAG_XDA_t;

#define     LSM303C_MAG_XDA_MASK      0x01
status_t LSM303C_MAG_R_XDA(void *handle, LSM303C_MAG_XDA_t *value);

/*******************************************************************************
* Register      : STATUS_REG
* Address       : 0X67
* Bit Group Name: YDA
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_MAG_YDA_EV_OFF         =0x00,
    LSM303C_MAG_YDA_EV_ON          =0x02,
} LSM303C_MAG_YDA_t;

#define     LSM303C_MAG_YDA_MASK      0x02
status_t LSM303C_MAG_R_YDA(void *handle, LSM303C_MAG_YDA_t *value);

/*******************************************************************************
* Register      : STATUS_REG
* Address       : 0X67
* Bit Group Name: ZDA
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_MAG_ZDA_EV_OFF         =0x00,
    LSM303C_MAG_ZDA_EV_ON          =0x04,
} LSM303C_MAG_ZDA_t;

#define     LSM303C_MAG_ZDA_MASK      0x04
status_t LSM303C_MAG_R_ZDA(void *handle, LSM303C_MAG_ZDA_t *value);

/*******************************************************************************
* Register      : STATUS_REG
* Address       : 0X67
* Bit Group Name: ZYXDA
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_MAG_ZYXDA_EV_OFF       =0x00,
    LSM303C_MAG_ZYXDA_EV_ON        =0x08,
} LSM303C_MAG_ZYXDA_t;

#define     LSM303C_MAG_ZYXDA_MASK    0x08
status_t LSM303C_MAG_R_ZYXDA(void *handle, LSM303C_MAG_ZYXDA_t *value);

/*******************************************************************************
* Register      : STATUS_REG
* Address       : 0X67
* Bit Group Name: XOR
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_MAG_XOR_EV_OFF         =0x00,
    LSM303C_MAG_XOR_EV_ON          =0x10,
} LSM303C_MAG_XOR_t;

#define     LSM303C_MAG_XOR_MASK      0x10
status_t LSM303C_MAG_R_XOR(void *handle, LSM303C_MAG_XOR_t *value);

/*******************************************************************************
* Register      : STATUS_REG
* Address       : 0X67
* Bit Group Name: YOR
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_MAG_YOR_EV_OFF         =0x00,
    LSM303C_MAG_YOR_EV_ON          =0x20,
} LSM303C_MAG_YOR_t;

#define     LSM303C_MAG_YOR_MASK      0x20
status_t LSM303C_MAG_R_YOR(void *handle, LSM303C_MAG_YOR_t *value);

/*******************************************************************************
* Register      : STATUS_REG
* Address       : 0X67
* Bit Group Name: ZOR
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_MAG_ZOR_EV_OFF         =0x00,
    LSM303C_MAG_ZOR_EV_ON          =0x40,
} LSM303C_MAG_ZOR_t;

#define     LSM303C_MAG_ZOR_MASK      0x40
status_t LSM303C_MAG_R_ZOR(void *handle, LSM303C_MAG_ZOR_t *value);

/*******************************************************************************
* Register      : STATUS_REG
* Address       : 0X67
* Bit Group Name: ZYXOR
* Permission    : RO
*******************************************************************************/
typedef enum {
    LSM303C_MAG_ZYXOR_EV_OFF       =0x00,
    LSM303C_MAG_ZYXOR_EV_ON        =0x80,
} LSM303C_MAG_ZYXOR_t;

#define     LSM303C_MAG_ZYXOR_MASK    0x80
status_t LSM303C_MAG_R_ZYXOR(void *handle, LSM303C_MAG_ZYXOR_t *value);
/*******************************************************************************
* Register      : <REGISTER_L> - <REGISTER_H>
* Output Type   : Magnetic
* Permission    : ro 
*******************************************************************************/
status_t LSM303C_MAG_Get_Raw_Magnetic(void *handle, u8_t *buff);
status_t LSM303C_MAG_Get_Magnetic(void *handle, int *buff);

/*******************************************************************************
* Register      : <REGISTER_L> - <REGISTER_H>
* Output Type   : IntThreshld
* Permission    : rw 
*******************************************************************************/
status_t LSM303C_MAG_Get_IntThreshld(void *handle, u8_t *buff); 
status_t LSM303C_MAG_Set_IntThreshld(void *handle, u8_t *buff);

#ifdef __cplusplus
}
#endif

#endif
