#include "WizziComSys.h"

#if 1
    #define SYS_DPRINT(...)         DPRINT(__VA_ARGS__)
    #define SYS_DPRINT_DATA(...)    DPRINT_DATA(__VA_ARGS__)
    #define SYS_FPRINT(...)         FPRINT(__VA_ARGS__)
    #define SYS_FLUSH()             FLUSH()
#else
    #define SYS_DPRINT(...);
    #define SYS_DPRINT_DATA(...);
    #define SYS_FPRINT(...);
    #define SYS_FLUSH();
#endif

void wizzi_sys_reset(WizziCom* com, WizziComPacket_t* pkt)
{
    SYS_DPRINT("RESET HOST COMMAND\r\n");
    SYS_FLUSH();
    
    FREE(pkt);
    
    // Reset device
    NVIC_SystemReset();
}

void wizzi_sys_pong(WizziCom* com, WizziComPacket_t* pkt)
{
    SYS_DPRINT("PING\r\n");
    
    FREE(pkt);

    // Respond to PING
    com->send(WizziComPacketSysPong, 0, NULL);
}

WizziComSys::WizziComSys(WizziCom* com) :
_com(com),
_pong(0)
{
    // catch PING response
    _com->attach(this, &WizziComSys::_catch_pong, WizziComPacketSysPong);
    // Respond to external PING
    _com->attach(wizzi_sys_pong, WizziComPacketSysPing);
    // catch Reset command
    _com->attach(wizzi_sys_reset, WizziComPacketSysReset);
}

WizziComSys::~WizziComSys()
{}

void WizziComSys::_catch_pong(WizziCom* com, WizziComPacket_t* pkt)
{
    FREE(pkt);
    _pong.release();
}

int WizziComSys::ping(void)
{
    Timer tim;
    int ret;
    
    // Empty pong semaphore
    while(_pong.wait(0));
    
    _com->send(WizziComPacketSysPing, 0, NULL);
    tim.start();
    _pong.wait(1000);
    
    ret = tim.read_ms();
    return (ret >= 999)? -1 : ret;
}
