#ifndef _WIZZI_MODEM_H_
#define _WIZZI_MODEM_H_

#include "mbed.h"
#include "rtos.h"
#include "WizziCom.h"
#include "WizziDebug.h"

#define TYPEDEF_STRUCT_PACKED   typedef struct __attribute__((packed))


typedef enum {
    WM_ERR_NONE             = 0,
    WM_ERR_NOT_READY        = 1,
    WM_ERR_COM_LINK         = 2,
    WM_ERR_ILLEGAL_FID      = 3,
    WM_ERR_ILLEGAL_FILE_DEF = 4,

    WM_ERR_UNKNOWN     = 0xff
} wm_error_code_t;

typedef union {
    uint32_t w;
    struct {
        uint32_t cause          : 8;
        uint32_t rfu            : 8;
        uint32_t nb_boot        :16;
    } bf;
} boot_status_t;

typedef struct {
    union {
        uint8_t      b[8];
        uint32_t     w[2];
    } uid;
    uint8_t calib;
} wm_status_t;


TYPEDEF_STRUCT_PACKED {
    uint8_t  fid;
    uint8_t  type;
    uint8_t  afid;
    uint8_t  ifid;
    uint8_t  prop;
    uint8_t  perm;
    uint32_t size;
    uint32_t alloc;
} register_file_param_t;

typedef union {
    uint32_t w;
    struct {
        uint32_t fid            : 8;
        uint32_t offset         : 12;
        uint32_t size           : 12;
    } bf;
} notify_file_param_t;

class WizziComModem {
    typedef void (*WizziComModemBootCallback)(boot_status_t);
    typedef void (*WizziComModemErrorCallback)(int8_t);
    
private:
    WizziCom*                   _com;
    PinName                     _reset_pin;
    Semaphore                   _modem_ready;
    Callback<void(boot_status_t)> _boot_callback;
    Callback<void(int8_t)>      _error_callback;
    
    void                        _modem_command(WizziCom* com, WizziComPacket_t* pkt);
    
public:
    WizziComModem(WizziCom* com, PinName reset_pin = NC);
    ~WizziComModem();

    void attach_boot(WizziComModemBootCallback function);
    
    template<class T>
    void attach_boot(T* object, void (T::*member)(boot_status_t))
    {
        _boot_callback = callback(object, member);
    }
    
    void attach_error(WizziComModemErrorCallback function);
    
    template<class T>
    void attach_error(T* object, void (T::*member)(boot_status_t))
    {
        _error_callback = callback(object, member);
    }

    void start_dash7(void);
    void stop_dash7(void);
    void software_reset(void);
    void hardware_reset(void);
};

#endif