#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "revision.h"
#include "d7a_1x.h"
#include "alp_spec.h"
#include "alp_helpers.h"
#include "modem_ref.h"

#define STATUS_MAX_DEVICES      (8)

TYPEDEF_STRUCT_PACKED
{
    uint8_t lb;
    uint8_t uid[D7A_UID_LEN];
} device_t;

TYPEDEF_STRUCT_PACKED
{
    uint8_t nb;
    device_t dev[STATUS_MAX_DEVICES];
} status_t;

#define FID_HOST_REV            65
#define SIZE_HOST_REV           sizeof(revision_t)
extern alp_file_header_t        h_rev;
extern revision_t               f_rev;

#define FID_STATUS              131
#define SIZE_STATUS             sizeof(status_t)
extern alp_file_header_t        h_status;
extern status_t                 f_status;

#endif // _FILE_H_