#ifndef _SENSORS_H_
#define _SENSORS_H_

#include "hts221/hts221_class.h"
#include "lis3mdl/lis3mdl_class.h"
#include "lps25h/lps25h_class.h"
#include "lsm6ds0/lsm6ds0_class.h"
#include "lsm303c/LSM303C_ACC_Sensor.h"
#include "lsm303c/LSM303C_MAG_Sensor.h"

#if defined(TARGET_STM32L152RE)
extern LIS3MDL *magnetometer;
extern LSM6DS0 *accelerometer;
extern LSM6DS0 *gyroscope;
#elif defined(TARGET_STM32L432KC)
extern LSM303C_ACC_Sensor *accelerometer;
extern LSM303C_MAG_Sensor *magnetometer;
#endif
extern LPS25H *pressure_sensor;
extern LPS25H *temp_sensor2;
extern HTS221 *humidity_sensor;
extern HTS221 *temp_sensor1;

bool Init_HTS221(HTS221* ht_sensor);
bool Init_LIS3MDL(LIS3MDL* magnetometer);
bool Init_LPS25H(LPS25H* pt_sensor);
bool Init_LSM6DS0(LSM6DS0* gyro_lsm6ds0);
bool Init_LSM303C_ACC(LSM303C_ACC_Sensor* accelerometer);
bool Init_LSM303C_MAG(LSM303C_MAG_Sensor* magnetometer);

bool mag_get_value(int32_t* buf);
bool acc_get_value(int32_t* buf);
bool gyr_get_value(int32_t* buf);
bool pre_get_value(int32_t* buf);
bool hum_get_value(int32_t* buf);
bool tem1_get_value(int32_t* buf);
bool tem2_get_value(int32_t* buf);
bool light_get_value(int32_t* buf);


#endif // _SENSORS_H_