#include "files.h"
#include "hwcfg.h"

#include "kal_fs.h"

#define __DEVICE_ID__               0x00000010

alp_file_header_t h_rev = {
    .perm = RWR_R_,
    .prop = FS_PERMANENT_NOTIF,
    .afid = FID_ACTP_RPT_FULL,
    .ifid = IFID_REPORT,
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(revision_t)),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(revision_t))
};

revision_t f_rev = {
    .manufacturer_id     = __MANUFACTURER_ID__,
    /// Device ID: Arbitrary number, at user/customer choice
    .device_id           = __DEVICE_ID__,
    /// Hardware Board ID:
    .hw_version          = __HW_VERSION__,
    /// Firmware Version: made of
    ///  - major,minor and patch indexes
    ///  - fw_id : "build-flavour"
    ///  FW_ID | MAJOR | MINOR | PATCH | HASH |
    //     1B  |  1B   |  1B   |   2B  |  4B  |
    .fw_version.id       = 2,
    .fw_version.major    = 3,
    .fw_version.minor    = 0,
    .fw_version.patch    = 5,
    .fw_version.hash     = 0x20200528,
    /// Not used
    .cup_max_size        = 0x00000000
};

alp_file_header_t h_alarm = {
    .perm = RWRWR_,
    .prop = FS_VOLATILE,
    .afid = 0,
    .ifid = 0,
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(uint8_t)),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(uint8_t))
};

uint8_t f_alarm = 255;

#define HEADER_FILE_SENSOR_CONFIG(name) const alp_file_header_t h_sensor_config_##name = {\
    .perm = RWRWR_,\
    .prop = FS_VOLATILE,\
    .afid = 0,\
    .ifid = 0,\
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(sensor_config_t)),\
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(sensor_config_t))\
}

#define HEADER_FILE_SENSOR_VALUE(name,_size) const alp_file_header_t h_sensor_value_##name = {\
    .perm = RWRWR_,\
    .prop = FS_VOLATILE_NOTIF,\
    .afid = FID_ACTP_RPT_FULL,\
    .ifid = IFID_REPORT,\
    .size = HAL_U32_BYTE_SWAP((uint32_t)(_size)),\
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)(_size))\
}


#define DATA_FILE_SENSOR_VALUE(name,_size) int32_t f_sensor_value_##name[_size] = {0}

HEADER_FILE_SENSOR_CONFIG(mag);
HEADER_FILE_SENSOR_CONFIG(acc);
HEADER_FILE_SENSOR_CONFIG(gyr);
HEADER_FILE_SENSOR_CONFIG(pre);
HEADER_FILE_SENSOR_CONFIG(hum);
HEADER_FILE_SENSOR_CONFIG(tem1);
HEADER_FILE_SENSOR_CONFIG(tem2);
HEADER_FILE_SENSOR_CONFIG(light);

HEADER_FILE_SENSOR_VALUE(mag, 3*sizeof(int32_t));
HEADER_FILE_SENSOR_VALUE(acc, 3*sizeof(int32_t));
HEADER_FILE_SENSOR_VALUE(gyr, 3*sizeof(int32_t));
HEADER_FILE_SENSOR_VALUE(pre, 1*sizeof(int32_t));
HEADER_FILE_SENSOR_VALUE(hum, 1*sizeof(int32_t));
HEADER_FILE_SENSOR_VALUE(tem1, 1*sizeof(int32_t));
HEADER_FILE_SENSOR_VALUE(tem2, 1*sizeof(int32_t));
HEADER_FILE_SENSOR_VALUE(light, 1*sizeof(int32_t));

DATA_FILE_SENSOR_VALUE(mag, 3);
DATA_FILE_SENSOR_VALUE(acc, 3);
DATA_FILE_SENSOR_VALUE(gyr, 3);
DATA_FILE_SENSOR_VALUE(pre, 1);
DATA_FILE_SENSOR_VALUE(hum, 1);
DATA_FILE_SENSOR_VALUE(tem1, 1);
DATA_FILE_SENSOR_VALUE(tem2, 1);
DATA_FILE_SENSOR_VALUE(light, 1);

sensor_config_t f_sensor_config_mag = {
    .report_type = REPORT_ON_DIFFERENCE,
    .read_period = 1000,
    .max_period = 3600,
    .max_diff = 500,
    .threshold_high = 1000,
    .threshold_low = -1000,
};
    
sensor_config_t f_sensor_config_acc = {
    .report_type = REPORT_ON_DIFFERENCE,
    .read_period = 1000,
    .max_period = 3600,
    .max_diff = 100,
    .threshold_high = 500,
    .threshold_low = -500,
};

sensor_config_t f_sensor_config_gyr = {
    .report_type = REPORT_ON_DIFFERENCE,
    .read_period = 1000,
    .max_period = 3600,
    .max_diff = 1000,
    .threshold_high = 10000,
    .threshold_low = -10000,
};

sensor_config_t f_sensor_config_pre = {
    .report_type = REPORT_ON_DIFFERENCE,
    .read_period = 1000,
    .max_period = 3600,
    .max_diff = 100,
    .threshold_high = 120000,
    .threshold_low = 90000,
};

sensor_config_t f_sensor_config_hum = {
    .report_type = REPORT_ON_DIFFERENCE,
    .read_period = 1000,
    .max_period = 3600,
    .max_diff = 100,
    .threshold_high = 7000,
    .threshold_low = 3000,
};

sensor_config_t f_sensor_config_tem1 = {
    .report_type = REPORT_ON_DIFFERENCE,
    .read_period = 1000,
    .max_period = 3600,
    .max_diff = 100,
    .threshold_high = 3500,
    .threshold_low = 2000,
};

sensor_config_t f_sensor_config_tem2 = {
    .report_type = REPORT_ON_DIFFERENCE,
    .read_period = 1000,
    .max_period = 3600,
    .max_diff = 100,
    .threshold_high = 9000,
    .threshold_low = 7000,
};

sensor_config_t f_sensor_config_light = {
    .report_type = REPORT_ON_DIFFERENCE,
    .read_period = 1000, // ms
    .max_period = 3600, // sec
    .max_diff = 100,
    .threshold_high = 0, // disabled
    .threshold_low = 1000, // disabled
};