#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "revision.h"
#include "alp_spec.h"
#include "alp_helpers.h"
#include "modem_ref.h"

TYPEDEF_STRUCT_PACKED {
    uint8_t fid;
    uint32_t offset;
    uint32_t length;
} touch_t;

extern Queue<touch_t, 8> g_file_modified;

// Types of reporting
typedef enum 
{
    REPORT_ALWAYS,
    REPORT_ON_DIFFERENCE,
    REPORT_ON_THRESHOLD,
} report_type_t;

// Sensor reporting configuration
TYPEDEF_STRUCT_PACKED 
{
    uint8_t  report_type;       // Type of report asked
    uint32_t read_period;       // Measure period (ms)
    uint32_t max_period;        // Maximum time between reports (s)
    uint32_t max_diff;          // Maximum difference allowed between two reported values
    int32_t  threshold_high;    // High threshold value triggering a report
    int32_t  threshold_low;     // Low threshold value triggering a report
} sensor_config_t;

#define FID_HOST_REV            65
#define SIZE_HOST_REV           sizeof(revision_t)
extern alp_file_header_t        h_rev;
extern revision_t               f_rev;

#define FID_ALARM               131
#define SIZE_ALARM              sizeof(uint8_t)
extern alp_file_header_t        h_alarm;
extern uint8_t                  f_alarm;

#define FILE_DECLARE_SENSOR_CONFIG(name) extern const alp_file_header_t h_sensor_config_##name;\
    extern sensor_config_t f_sensor_config_##name

#define FILE_DECLARE_SENSOR_VALUE(name) extern const alp_file_header_t h_sensor_value_##name;\
    extern int32_t f_sensor_value_##name[]

#define FID_SENSOR_CONFIG_MAG           132
#define FID_SENSOR_CONFIG_ACC           133
#define FID_SENSOR_CONFIG_GYR           134
#define FID_SENSOR_CONFIG_PRE           135
#define FID_SENSOR_CONFIG_HUM           136
#define FID_SENSOR_CONFIG_TEM1          137
#define FID_SENSOR_CONFIG_TEM2          138
#define FID_SENSOR_CONFIG_LIGHT         139

#define FID_SENSOR_VALUE_MAG            150
#define FID_SENSOR_VALUE_ACC            151
#define FID_SENSOR_VALUE_GYR            152
#define FID_SENSOR_VALUE_PRE            153
#define FID_SENSOR_VALUE_HUM            154
#define FID_SENSOR_VALUE_TEM1           155
#define FID_SENSOR_VALUE_TEM2           156
#define FID_SENSOR_VALUE_LIGHT          157

FILE_DECLARE_SENSOR_CONFIG(mag);
FILE_DECLARE_SENSOR_CONFIG(acc);
FILE_DECLARE_SENSOR_CONFIG(gyr);
FILE_DECLARE_SENSOR_CONFIG(pre);
FILE_DECLARE_SENSOR_CONFIG(hum);
FILE_DECLARE_SENSOR_CONFIG(tem1);
FILE_DECLARE_SENSOR_CONFIG(tem2);
FILE_DECLARE_SENSOR_CONFIG(light);

FILE_DECLARE_SENSOR_VALUE(mag);
FILE_DECLARE_SENSOR_VALUE(acc);
FILE_DECLARE_SENSOR_VALUE(gyr);
FILE_DECLARE_SENSOR_VALUE(pre);
FILE_DECLARE_SENSOR_VALUE(hum);
FILE_DECLARE_SENSOR_VALUE(tem1);
FILE_DECLARE_SENSOR_VALUE(tem2);
FILE_DECLARE_SENSOR_VALUE(light);


#endif // _FILE_H_