// -----------------------------------------------
// TARGET Options
// -----------------------------------------------

#if defined(TARGET_STM32L152RE)

    //#define TARGET_HAS_IKS01A1

    // -----------------------------------------------
    // Select the sensors
    // -1 : disable, 0 : simu, 1 : hardware   
    // -----------------------------------------------
    #ifdef TARGET_HAS_IKS01A1    
        // use all sensors from IKS01A1 shield for Nucleo-64
        #define _MAG_EN_                (1)
        #define _ACC_EN_                (1)
        #define _GYR_EN_                (1)
        #define _PRE_EN_                (1)
        #define _HUM_EN_                (1)
        #define _TEM1_EN_               (1)
        #define _TEM2_EN_               (1)
    #else
        // simulate sensors
        #define _MAG_EN_                (0)
        #define _ACC_EN_                (0)
        #define _GYR_EN_                (0)
        #define _PRE_EN_                (0)
        #define _HUM_EN_                (0)
        #define _TEM1_EN_               (0)
        #define _TEM2_EN_               (0)
    #endif // TARGET_HAS_IKS01A1
    
    #define _LIGHT_EN_                  (-1)

#elif defined(TARGET_STM32L432KC)
    // Enable this if WISENSE2 is populated with LSM303C (instead of LSM303AGR)
    #define TARGET_HAS_LSM303C
 
    // -----------------------------------------------
    // Select the sensors available on the sh2050
    // -1 : disable, 0 : simu, 1 : hardware   
    // -----------------------------------------------
    #define _MAG_EN_                (1)
    #define _ACC_EN_                (1)
    #define _GYR_EN_                (-1)
    #define _PRE_EN_                (1)
    #define _HUM_EN_                (1)
    #define _TEM1_EN_               (1)
    #define _TEM2_EN_               (1)
    #define _LIGHT_EN_              (1)
    
#else
    #error "Please choose or add the right platform."
#endif