#ifndef __SENSOR_H__
#define __SENSOR_H__

#include "hal_types.h"

typedef uint16_t light_value_t;

// Types of reporting
typedef enum 
{
    REPORT_ALWAYS,
    REPORT_ON_DIFFERENCE,
    REPORT_ON_THRESHOLD,
} report_type_t;

// Sensor reporting configuration
TYPEDEF_STRUCT_PACKED 
{
    uint8_t  report_type;       // Type of report asked
    uint32_t read_period;       // Measure period (ms)
    uint32_t max_period;        // Maximum time between reports (s)
    uint32_t max_diff;          // Maximum difference allowed between two reported values
    int32_t  threshold_high;    // High threshold value triggering a report
    int32_t  threshold_low;     // Low threshold value triggering a report
} sensor_config_t;

light_value_t sensor_get_light(void);

#endif