#include "mbed.h"
#include "hwcfg.h"
#include "sensor.h"
#include "WizziDebug.h"


#if defined(SENSOR_LIGHT_MEAS) && defined(SENSOR_LIGHT_EN)

AnalogIn g_light_meas(SENSOR_LIGHT_MEAS);
DigitalOut g_light_en_l(SENSOR_LIGHT_EN);


light_value_t sensor_get_light(void)
{
    light_value_t light_level = 0;
    
    // Enable light sensor
    g_light_en_l = 0;
    
    Thread::wait(10);
    
    // Read light value
    light_level = (light_value_t)(1000*g_light_meas);
    
    // Disable light sensor
    g_light_en_l = 1;
    
    return light_level;
}
#else
    #error Please define some sensor
#endif