#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "revision.h"
#include "alp_spec.h"
#include "alp_helpers.h"
#include "modem_ref.h"

TYPEDEF_STRUCT_PACKED {
    uint8_t fid;
    uint32_t offset;
    uint32_t length;
} touch_t;

extern Queue<touch_t, 8> modem_resp;

#define FID_HOST_REV            65
#define SIZE_HOST_REV           sizeof(revision_t)
extern alp_file_header_t        h_rev;
extern revision_t               f_rev;

#define FID_ALARM               131
#define SIZE_ALARM              sizeof(uint8_t)
extern alp_file_header_t        h_alarm;
extern uint8_t                  f_alarm;


#endif // _FILE_SYS_H_
