#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "revision.h"
#include "alp_spec.h"
#include "alp_helpers.h"
#include "modem_ref.h"

TYPEDEF_STRUCT_PACKED {
    uint8_t fid;
    uint32_t offset;
    uint32_t length;
} touch_t;

extern Queue<touch_t, 8> g_file_modified;

#define FID_HOST_REV                65
#define SIZE_HOST_REV               sizeof(revision_t)
extern const alp_file_header_t      h_rev;
extern const revision_t             f_rev;

#define FID_STRING_FILE             132
#define SIZE_STRING_FILE            128
extern const alp_file_header_t      h_string_file;
extern uint8_t                      f_string_file[SIZE_STRING_FILE];

#define FID_STATUS_FILE             133
#define SIZE_STATUS_FILE            sizeof(uint8_t)
extern const alp_file_header_t      h_status_file;
extern uint8_t                      f_status_file;

// No local data since the file will be created on the modem


#endif // _FILE_H_