#include "files.h"
#include "hwcfg.h"

#include "kal_fs.h"

#define __DEVICE_ID__               0x00000016

const alp_file_header_t h_rev = {
    .perm = RWR_R_,
    .prop = FS_PERMANENT_NOTIF,
    .afid = FID_ACTP_RPT_FULL,
    .ifid = IFID_REPORT,
    .size = HAL_U32_BYTE_SWAP((uint32_t)SIZE_HOST_REV),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)SIZE_HOST_REV)
};

const revision_t f_rev = {
    .manufacturer_id     = __MANUFACTURER_ID__,
    /// Device ID: Arbitrary number, at user/customer choice
    .device_id           = __DEVICE_ID__,
    /// Hardware Board ID:
    .hw_version          = __HW_VERSION__,
    /// Firmware Version: made of
    ///  - major,minor and patch indexes
    ///  - fw_id : "build-flavour"
    ///  FW_ID | MAJOR | MINOR | PATCH | HASH |
    //     1B  |  1B   |  1B   |   2B  |  4B  |
    .fw_version.id       = 0,
    .fw_version.major    = 2,
    .fw_version.minor    = 0,
    .fw_version.patch    = 0,
    .fw_version.hash     = 0x20200528,
    /// Not used
    .cup_max_size        = 0x00000000
};

const alp_file_header_t h_string_file = {
    .perm = RWRWRW,
    .prop = FS_VOLATILE,
    .afid = 0,
    .ifid = 0,
    .size = HAL_U32_BYTE_SWAP((uint32_t)SIZE_STRING_FILE),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)SIZE_STRING_FILE)
};

uint8_t f_string_file[SIZE_STRING_FILE] = "Default string value";

const alp_file_header_t h_status_file = {
    .perm = RWRWR_,
    .prop = FS_VOLATILE_NOTIF,
    .afid = FID_ACTP_RPT_FULL,
    .ifid = IFID_REPORT,
    .size = HAL_U32_BYTE_SWAP((uint32_t)SIZE_STATUS_FILE),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)SIZE_STATUS_FILE)
};

uint8_t f_status_file = 0;
