#include "modem_d7a.h"

// ============================================================}}}

// Callbacks to MODEM's ALP requests
// ============================================================{{{
void my_read(u8 action, u8 fid, u32 offset, u32 length, int id)
{
    modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
}

void my_write(u8 action, u8 fid, void *data, u32 offset, u32 length, int id)
{
    modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
}

void my_read_fprop(u8 action, u8 fid, int id)
{
    modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
}

void my_flush(u8 action, u8 fid, int id)
{
    modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
}

void my_delete(u8 action, u8 fid, int id)
{
    modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
}

void my_reset(void)
{
    PRINT("Restarting application...\r\n");
    FLUSH();
    NVIC_SystemReset();
}

void my_boot(u8 cause, u16 number)
{
    PRINT("Modem BOOT[%c] #%d\r\n", cause, number);
    
    // Modem re-booted, restart APP
    my_reset();
}