#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "revision.h"
#include "alp_spec.h"
#include "alp_helpers.h"
#include "modem_ref.h"

#define sizeof_field(_struct,_field) sizeof(((_struct*)0)->_field)

TYPEDEF_STRUCT_PACKED {
    uint8_t fid;
    uint32_t offset;
    uint32_t length;
} touch_t;

extern Queue<touch_t, 8> g_file_modified;

TYPEDEF_STRUCT_PACKED {
    uint8_t data[1024];
    uint32_t crc;
} output_file_t;

TYPEDEF_STRUCT_PACKED {
    uint8_t data[1024];
    uint32_t crc;
} input_file_t;

#define FID_HOST_REV            65
#define SIZE_HOST_REV           sizeof(revision_t)
extern alp_file_header_t        h_rev;
extern revision_t               f_rev;

#define FID_OUTPUT_FILE         200
#define SIZE_OUTPUT_FILE        sizeof(output_file_t)
extern alp_file_header_t        h_output_file;
extern output_file_t            f_output_file;

#define FID_INPUT_FILE          201
#define SIZE_INPUT_FILE         sizeof(input_file_t)
extern alp_file_header_t        h_input_file;
extern input_file_t             f_input_file;

#endif // _FILE_H_