#include "files.h"
#include "hwcfg.h"

#include "kal_fs.h"

#define __DEVICE_ID__               0x00000018

alp_file_header_t h_rev = {
    .perm = RWR_R_,
    .prop = FS_PERMANENT_NOTIF,
    .afid = FID_ACTP_RPT_FULL,
    .ifid = IFID_REPORT,
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(revision_t)),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(revision_t))
};

revision_t f_rev = {
    .manufacturer_id     = __MANUFACTURER_ID__,
    /// Device ID: Arbitrary number, at user/customer choice
    .device_id           = __DEVICE_ID__,
    /// Hardware Board ID:
    .hw_version          = __HW_VERSION__,
    /// Firmware Version: made of
    ///  - major,minor and patch indexes
    ///  - fw_id : "build-flavour"
    ///  FW_ID | MAJOR | MINOR | PATCH | HASH |
    //     1B  |  1B   |  1B   |   2B  |  4B  |
    .fw_version.id       = 0,
    .fw_version.major    = 2,
    .fw_version.minor    = 0,
    .fw_version.patch    = 0,
    .fw_version.hash     = 0x20200528,
    /// Not used
    .cup_max_size        = 0x00000000
};

alp_file_header_t h_output_file = {
    .perm = RWRWRW,
    .prop = FS_VOLATILE,
    .afid = 0,
    .ifid = 0,
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(output_file_t)),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(output_file_t))
};

output_file_t f_output_file = {
    .data = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec id pulvinar est. Mauris pretium arcu at facilisis rutrum. Nulla facilisi. "
            "Quisque auctor, massa et gravida semper, libero dui varius est, quis ornare dolor odio a turpis. Suspendisse in turpis vel risus porta "
            "aliquet et a nibh. Mauris vehicula purus ut risus convallis, id luctus erat tincidunt. Aenean vitae gravida nisi. Nulla eleifend lorem "
            "purus, non sagittis neque accumsan molestie. "
            "Praesent interdum semper viverra. Cras ut sodales quam. Etiam vitae orci sit amet lorem semper commodo. Phasellus elementum nec dui eget "
            "pellentesque. Proin eget dignissim nibh. In iaculis imperdiet enim, consequat gravida mi varius sed. Suspendisse eu elementum justo. "
            "Donec non mauris odio. Sed aliquet vestibulum risus non ultricies. Integer mollis neque id magna gravida auctor. Cras at auctor velit. "
            "Vivamus tempor dui purus, id commodo arcu iaculis a. Curabitur hendrerit, nibh sit amet gravida porttitor, leo magna gravida ex, non "
            "porta ligula quam ac risus. Mauri",
    .crc = 0,
};

alp_file_header_t h_input_file = {
    .perm = RWRWRW,
    .prop = FS_VOLATILE,
    .afid = 0,
    .ifid = 0,
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(input_file_t)),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(input_file_t))
};

input_file_t f_input_file = {
    .data = {0},
    .crc = 0,
};