#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "revision.h"
#include "alp_spec.h"
#include "alp_helpers.h"
#include "modem_ref.h"
#include "cup.h"

TYPEDEF_STRUCT_PACKED {
    uint8_t fid;
    uint32_t offset;
    uint32_t length;
} touch_t;

extern Queue<touch_t, 8> g_file_modified;

extern alp_file_header_t        h_rev;
extern revision_t               f_rev;

extern alp_file_header_t        h_cup_cfg;
extern cup_cfg_t                f_cup_cfg;

extern alp_file_header_t        h_cup_cfg_bcast;
extern cup_cfg_bcast_t          f_cup_cfg_bcast;

#define CUP_FILE_MAX_SIZE       (158*8*128)
extern alp_file_header_t        h_cup_code;

#endif // _FILE_H_