#include "files.h"
#include "hwcfg.h"

#include "kal_fs.h"

#define __DEVICE_ID__               0x00000019

alp_file_header_t h_rev = {
    .perm = RWR_R_,
    .prop = FS_PERMANENT_NOTIF,
    .afid = FID_ACTP_RPT_FULL,
    .ifid = IFID_REPORT,
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(revision_t)),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(revision_t))
};

revision_t f_rev = {
    .manufacturer_id     = __MANUFACTURER_ID__,
    /// Device ID: Arbitrary number, at user/customer choice
    .device_id           = __DEVICE_ID__,
    /// Hardware Board ID:
    .hw_version          = __HW_VERSION__,
    /// Firmware Version: made of
    ///  - major,minor and patch indexes
    ///  - fw_id : "build-flavour"
    ///  FW_ID | MAJOR | MINOR | PATCH | HASH |
    //     1B  |  1B   |  1B   |   2B  |  4B  |
    .fw_version.id       = 0,
    .fw_version.major    = 2,
    .fw_version.minor    = 0,
    .fw_version.patch    = 0,
    .fw_version.hash     = 0x20200528,
    /// Maximum size for CUP code
    .cup_max_size        = CUP_FILE_MAX_SIZE
};

alp_file_header_t h_cup_cfg = {
    .perm = RW____, // This file is accessed as ROOT
    .prop = FS_VOLATILE,
    .afid = 0,
    .ifid = 0,
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(cup_cfg_t)),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(cup_cfg_t))
};

cup_cfg_t f_cup_cfg = { 0 };

alp_file_header_t h_cup_cfg_bcast = {
    .perm = RWRWR_,
    .prop = FS_VOLATILE,
    .afid = 0,
    .ifid = 0,
    .size = HAL_U32_BYTE_SWAP((uint32_t)sizeof(cup_cfg_bcast_t)),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)sizeof(cup_cfg_bcast_t))
};

cup_cfg_bcast_t f_cup_cfg_bcast = { 0 };

alp_file_header_t h_cup_code = {
    .perm = RWRWRW, // This file is written as GUEST (no encryption)
    .prop = FS_PERMANENT,
    .afid = 0,
    .ifid = 0,
    .size = HAL_U32_BYTE_SWAP((uint32_t)CUP_FILE_MAX_SIZE),
    .alloc= HAL_U32_BYTE_SWAP((uint32_t)CUP_FILE_MAX_SIZE)
};
