#include "modem_d7a.h"
#include "files.h"
#include "fast_crc32.h"

#define SERIAL_MAX_PACKET_SIZE  (255)

uint32_t stream_crc = 0;
uint16_t last_end=0;

// ============================================================}}}

// Callbacks to MODEM's ALP requests
// ============================================================{{{
void my_read(u8 action, u8 fid, u32 offset, u32 length, int id)
{
    u8 data[SERIAL_MAX_PACKET_SIZE];
    
    ASSERT((ALP_ACTION_RSP_TAG_SIZE + ALP_ACTION_RSP_F_DATA_SIZE(offset, length)) <= SERIAL_MAX_PACKET_SIZE,
    "Read response too big for serial protocol (%d/%dmax)\r\n", length, ALP_ACTION_RSP_TAG_SIZE + ALP_ACTION_RSP_F_DATA_SIZE(offset,SERIAL_MAX_PACKET_SIZE));
    
    if (ram_fs_read(fid, data, offset, length))
    {
        modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
    }
    else
    {
        modem_ref_respond_read(fid, data, offset, length, id);
    }
}

void my_write(u8 action, u8 fid, void *data, u32 offset, u32 length, int id)
{
    if (!ram_fs_write(fid, (uint8_t*)data, offset, length) || FID_APP_CUP_CODE == fid)
    {
        touch_t* touch = (touch_t*)MALLOC(sizeof(touch_t));
                        
        if (FID_APP_CUP_CODE == fid)
        {
            // Calculate crc on chunk
            if (offset+length>last_end)
            {
                // Only calculate on new chunks, ignore repeated chunks
                // If we missed some chunks the CRC will be bad anyway
                stream_crc = crc32_fast(data, length, stream_crc);
            }
            last_end=offset+length;

            /************************/
            /* Save the chunk data. */
            /************************/
        }
        else if (FID_APP_CUP_CFG == fid)
        {
            // Reset last offset when entering CUP mode (and also exiting)
            last_end = 0;
        }
        
        touch->fid = fid;
        touch->offset = offset;
        touch->length = length;

        g_file_modified.put(touch);

        modem_ref_respond(action, ALP_ERR_NONE, id);
    }
    else
    {
        modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
    }
}

void my_read_fprop(u8 action, u8 fid, int id)
{
    alp_file_header_t* hdr = (alp_file_header_t*)ram_fs_get_header(fid);
    
    if (hdr != NULL)
    {
        modem_ref_respond_fprop(fid, hdr, id);
    }
    else
    {
        modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
    }
}

void my_flush(u8 action, u8 fid, int id)
{
    // No flush in this file system
    modem_ref_respond(action, ALP_ERR_NONE, id);
}

void my_delete(u8 action, u8 fid, int id)
{
    modem_ref_respond(action, ALP_ERR_FILE_NOT_FOUND, id);
}

void my_udata(alp_payload_t* alp)
{
    alp_payload_print(alp);
}

void my_lqual(u8 ifid, int per)
{
    PRINT("Interface File [%3d] LQUAL : %d%% PER\r\n", ifid, per);
}

void my_ldown(u8 ifid)
{
    PRINT("Interface File [%3d] LDOWN\r\n", ifid);
}

void my_reset(void)
{
    PRINT("Restarting application...\r\n");
    FLUSH();
    NVIC_SystemReset();
}

void my_boot(u8 cause, u16 number)
{
    PRINT("Modem BOOT[%c] #%d\r\n", cause, number);
    
    // Modem re-booted, restart APP
    my_reset();
}

void my_busy(u8 busy)
{
    if (busy)
    {
        PRINT("Modem Busy\r\n");
        
        /* Stop report, do not use modem */
        /* Wait for modem reboot or modem not busy */
    }
    else
    {
        PRINT("Modem not Busy\r\n");
        
        /* Resume reports */
    }
}