#ifndef _SENSORS_H_
#define _SENSORS_H_

#include "hts221/hts221_class.h"
#include "lis3mdl/lis3mdl_class.h"
#include "lps25h/lps25h_class.h"
#include "lsm6ds0/lsm6ds0_class.h"
#include "d7a.h"

// Simulate the sensors (if X_NUCLEO_IKS01A1 not connected)
//#define _SENSORS_SIMU_    1

extern LIS3MDL *magnetometer;
extern LSM6DS0 *accelerometer;
extern LSM6DS0 *gyroscope;
extern LPS25H *pressure_sensor;
extern LPS25H *temp_sensor2;
extern HTS221 *humidity_sensor;
extern HTS221 *temp_sensor1;


// Types of reporting
typedef enum {
    REPORT_ALWAYS,
    REPORT_ON_DIFFERENCE,
    REPORT_ON_THRESHOLD,
} report_type_t;

// Sensor reporting configuration
TYPEDEF_STRUCT_PACKED {
    uint8_t  report_type; // Type of report asked
    uint32_t period; // Measure period (ms)
    uint32_t max_period; // Maximum time between reports (s)
    uint32_t max_diff; // Maximum difference allowed between two reported values
    int32_t  threshold_high; // High threshold value triggering a report
    int32_t  threshold_low; // Low threshold value triggering a report
} sensor_config_t;

typedef struct
{
    // Number of data fields
    uint32_t nb_values;
    // Total size of data
    uint32_t data_size;
    // Read value function
    bool (*read_value)(int32_t*);
    // Last reported value
    int32_t* last_report_value;
    // Current measured value
    int32_t* current_value;
    // Time elapsed since last report (ms)
    uint32_t last_report_time;
    
    // File ID of the sensor value file
    uint8_t value_file_id;
    // Sensor configuration file ID
    uint8_t cfg_file_id;
    // Sensor configuration context
    sensor_config_t cfg;
} sensor_thread_ctx_t;


bool Init_HTS221(HTS221* ht_sensor);
bool Init_LIS3MDL(LIS3MDL* magnetometer);
bool Init_LPS25H(LPS25H* pt_sensor);
bool Init_LSM6DS0(LSM6DS0* gyro_lsm6ds0);

bool mag_get_value(int32_t* buf);
bool acc_get_value(int32_t* buf);
bool gyr_get_value(int32_t* buf);
bool pre_get_value(int32_t* buf);
bool hum_get_value(int32_t* buf);
bool tem1_get_value(int32_t* buf);
bool tem2_get_value(int32_t* buf);

#endif // _SENSORS_H_