#ifndef _FILES_H_
#define _FILES_H_

#include "mbed.h"
#include "d7a.h"
#include "sensors.h"


enum {
    ALARM_FILE_ID = 224,
    SIMUL_FILE_ID,
        
    MAG_CFG_FILE_ID = 240,
    ACC_CFG_FILE_ID,
    GYR_CFG_FILE_ID,
    PRE_CFG_FILE_ID,  // 243
    HUM_CFG_FILE_ID,
    TEM1_CFG_FILE_ID,
    TEM2_CFG_FILE_ID,
    MAG_VALUE_FILE_ID, // 247
    ACC_VALUE_FILE_ID,
    GYR_VALUE_FILE_ID,
    PRE_VALUE_FILE_ID, // 250
    HUM_VALUE_FILE_ID,
    TEM1_VALUE_FILE_ID,
    TEM2_VALUE_FILE_ID, // 253
};


#define GENERIC_FILE(name,data)         TYPEDEF_STRUCT_PACKED{\
                                            data\
                                        } name##_t;\
                                        extern name##_t f_##name;
                                    
#define GENERIC_FILE_INIT(name,...)     name##_t f_##name = {\
                                            __VA_ARGS__\
                                        }
                                        
#define GENERIC_FILE_MAP(fid,name)      { (void*)fid, (void*)&f_##name }



// Firmware revision for the Dash7board
GENERIC_FILE(dev_rev, d7a_revision_t rev;);

GENERIC_FILE(simul, uint32_t divider;);

GENERIC_FILE(mag_cfg, sensor_config_t cfg;);
GENERIC_FILE(acc_cfg, sensor_config_t cfg;);
GENERIC_FILE(gyr_cfg, sensor_config_t cfg;);
GENERIC_FILE(pre_cfg, sensor_config_t cfg;);
GENERIC_FILE(hum_cfg, sensor_config_t cfg;);
GENERIC_FILE(tem1_cfg, sensor_config_t cfg;);
GENERIC_FILE(tem2_cfg, sensor_config_t cfg;);

uint32_t fs_write_file(const uint8_t file_id,
                        const uint16_t offset,
                        const uint16_t size,
                        const uint8_t* const content);
                        
uint32_t fs_read_file( const uint8_t file_id,
                        const uint16_t offset,
                        const uint16_t size,
                        uint8_t* buf);

#endif // _FILE_SYS_H_
