#include "files.h"
#include "dbg.h"
#include "sensors.h"

GENERIC_FILE_INIT(dev_rev,
    .rev.manufacturer_id     = 0x01BC50C7,
    /// Device ID: Arbitrary number, at user/customer choice
    .rev.device_id           = 0x00000010,
    /// Hardware Board ID:
    .rev.hw_version          = 0x00000152,
    /// Firmware Version: made of
    ///  - major,minor and patch indexes
    ///  - fw_id : "build-flavour"
    ///  FW_ID | MAJOR | MINOR | PATCH | HASH |
    //     1B  |  1B   |  1B   |   2B  |  4B  |
#if _SENSORS_SIMU_
    .rev.fw_version.id       = 1,
#else
    .rev.fw_version.id       = 0,
#endif
    .rev.fw_version.major    = 1,
    .rev.fw_version.minor    = 0,
    .rev.fw_version.patch    = 0,
    .rev.fw_version.hash     = 0x00000000,
    /// "file-system" signature
    .rev.fs_crc              = 0x00000000,
);


GENERIC_FILE_INIT(simul,
    .divider = 500, // Boot value
);


GENERIC_FILE_INIT(mag_cfg,
    .cfg.report_type = REPORT_ON_DIFFERENCE,
    .cfg.period = 1000,
    .cfg.max_period = 300,
    .cfg.max_diff = 100,
    .cfg.threshold_high = 1000,
    .cfg.threshold_low = -1000,
);
    
GENERIC_FILE_INIT(acc_cfg,
    .cfg.report_type = REPORT_ON_DIFFERENCE,
    .cfg.period = 1000,
    .cfg.max_period = 300,
    .cfg.max_diff = 100,
    .cfg.threshold_high = 500,
    .cfg.threshold_low = -500,
);

GENERIC_FILE_INIT(gyr_cfg,
    .cfg.report_type = REPORT_ON_DIFFERENCE,
    .cfg.period = 1000,
    .cfg.max_period = 300,
    .cfg.max_diff = 1000,
    .cfg.threshold_high = 10000,
    .cfg.threshold_low = -10000,
);

GENERIC_FILE_INIT(pre_cfg,
    .cfg.report_type = REPORT_ON_DIFFERENCE,
    .cfg.period = 1000,
    .cfg.max_period = 60,
    .cfg.max_diff = 100,
    .cfg.threshold_high = 120000,
    .cfg.threshold_low = 90000,
);

GENERIC_FILE_INIT(hum_cfg,
    .cfg.report_type = REPORT_ON_DIFFERENCE,
    .cfg.period = 1000,
    .cfg.max_period = 60,
    .cfg.max_diff = 100,
    .cfg.threshold_high = 7000,
    .cfg.threshold_low = 3000,
);

GENERIC_FILE_INIT(tem1_cfg,
    .cfg.report_type = REPORT_ON_DIFFERENCE,
    .cfg.period = 1000,
    .cfg.max_period = 60,
    .cfg.max_diff = 100,
    .cfg.threshold_high = 3500,
    .cfg.threshold_low = 2000,
);

GENERIC_FILE_INIT(tem2_cfg,
    .cfg.report_type = REPORT_ON_DIFFERENCE,
    .cfg.period = 1000,
    .cfg.max_period = 60,
    .cfg.max_diff = 100,
    .cfg.threshold_high = 9000,
    .cfg.threshold_low = 7000,
);

#define FILE_QTY    8

static const void* file_map[FILE_QTY][2] = {
    GENERIC_FILE_MAP(MAG_CFG_FILE_ID, mag_cfg),
    GENERIC_FILE_MAP(ACC_CFG_FILE_ID, acc_cfg),
    GENERIC_FILE_MAP(GYR_CFG_FILE_ID, gyr_cfg),
    GENERIC_FILE_MAP(PRE_CFG_FILE_ID, pre_cfg),
    GENERIC_FILE_MAP(HUM_CFG_FILE_ID, hum_cfg),
    GENERIC_FILE_MAP(TEM1_CFG_FILE_ID, tem1_cfg),
    GENERIC_FILE_MAP(TEM2_CFG_FILE_ID, tem2_cfg),
    GENERIC_FILE_MAP(SIMUL_FILE_ID, simul),
};

void* file_get( uint8_t file_id )
{    
    for (uint8_t i=0 ; i<FILE_QTY ; i++)
    {
        if ((uint8_t)file_map[i][0] == file_id)
        {
            return (void*)file_map[i][1];
        }
    }
    
    ASSERT(false, "File %d does not exist\r\n");
    
    return NULL;
}

uint32_t fs_write_file(const uint8_t file_id,
                        const uint16_t offset,
                        const uint16_t size,
                        const uint8_t* const content)
{
    uint32_t file = 0;
    
    DPRINT("WF %d\r\n", file_id);
        
    // Retrieve pointer to file
    file = (uint32_t)file_get(file_id);
        
    if (!file)
    {
        return 0;
    }
    
    // Write the new data
    memcpy((void*)(file+offset), (void*)content, size);
  
    return size;
}

uint32_t fs_read_file( const uint8_t file_id,
                        const uint16_t offset,
                        const uint16_t size,
                        uint8_t* buf)
{
    uint32_t file = 0;
    
    DPRINT("RF %d\r\n", file_id);
    
    // Retrieve pointer to file
    file = (uint32_t)file_get(file_id);
    
    if (!file)
    {
        return 0;
    }
    
    // Read data
    memcpy((void*)buf, (void*)(file+offset), size);
    
    return size;
}
