#if 1
#include "mbed.h"
#include "lib/RWR_Utils/RWR_Utils.hxx"

DeepSleepLock lock;

Motor motorA(DRV_AENBL, DRV_APHASE); // left motor
Motor motorB(DRV_BENBL, DRV_BPHASE); // right motor

DigitalOut led(LED1);

DigitalOut espCHPD(ESP_CHPD);
DigitalOut espGPIO0(ESP_GPIO0);
DigitalOut espReset(ESP_RESET);
Serial esp(ESP_RX, ESP_TX, WEB_ESP_BAUD);

DigitalOut ctl(QTR_CTL);
AnalogIn qtrPins[SENSORS_BAR_SIZE] = {QTR_3,
  QTR_5,
  QTR_7,
  QTR_9,
  QTR_11,
  QTR_13};
QTR qtr(ctl, qtrPins, 15);

Serial serial(USBTX, USBRX, 115200);

web_settings_t webSettings = {
  WEB_MOTORS_ENABLED_DEFAULT,
  (int32_t) (PID_DEFAULT_KP * 1000),
  (int32_t) (PID_DEFAULT_KI * 1000),
  (int32_t) (PID_DEFAULT_KD * 1000),
};

int32_t PIDLastUpdateTime = 0;
Timer PIDUpdateTimer;

int main()
{
  uint32_t digitizedSensorsReading;
  uint32_t lastDigitizedSensorsReading;
  float speedMotorA;
  float speedMotorB;

  float PIDError = 0.0f;
  float PIDLastError = 0.0f;
  float PIDIntegrativeError = 0.0f;
  float PIDDerivativeError = 0.0f;
  float PIDOutput = 0.0f;

  motorA.setBrake(false);
  motorB.setBrake(false);

  espCHPD = 0;
  espReset = 0;
  espGPIO0 = 0;
  led = 0;

  wait(0.5);

  led = 1;

  esp.attach(&ESPReceiveIRQ, Serial::RxIrq);

  #ifdef ENABLE_PASSTHROUGH
    serial.attach(&USBReceiveIRQ, Serial::RxIrq);
  #endif

  PIDUpdateTimer.start();

  while(1)
  {
    ESPRunStateMachine();

    int32_t currentTime = PIDUpdateTimer.read_us();

    // handle timer overflow
    if (currentTime > PIDLastUpdateTime)
    {
      if (currentTime - PIDLastUpdateTime >= PID_UPDATE_PERIOD_US)
      {
        digitizedSensorsReading = qtr.readSensorsAsDigital();

        // all sensors on reflective surface, no line
        if (digitizedSensorsReading == 0U)
        {
          // TODO: reset PID errors here if needed
          if (lastDigitizedSensorsReading == 0U)
          {
            speedMotorA = NO_LINE_SPEED_MOTOR_A;
            speedMotorB = NO_LINE_SPEED_MOTOR_B;
          } else
          {
            digitizedSensorsReading = lastDigitizedSensorsReading;
          }
        } else
        // all sensors on black surface or lifted off the playfield
        if (digitizedSensorsReading == SENSORS_ALL_ONES)
        {
          // TODO: reset PID errors here if needed
          speedMotorA = 0.0f;
          speedMotorB = 0.0f;
        } else
        // line detected
        {
          // calculate PID errors
          PIDError = PID_SETPOINT - qtr.digitizedSensorsToFloat(digitizedSensorsReading);
          PIDIntegrativeError += PIDError;
          PIDDerivativeError = PIDError - PIDLastError;
          PIDOutput = (webSettings.Kp / 1000.0f) * PIDError + (webSettings.Ki / 1000.0f) * PIDIntegrativeError + (webSettings.Kd / 1000.0f) * PIDDerivativeError;

          // convert PID output to motor speeds
          // if line is on the right
          if(PIDOutput < 0.0f)
          {
            speedMotorA = 1.0f;
            speedMotorB = 1.0f + PIDOutput; // slow down right motor
          } else
          // if line is on the left
          if(PIDOutput > 0.0f)
          {
            speedMotorA = 1.0f - PIDOutput; // slow down left motor
            speedMotorB = 1.0f;
          }
          // line is centered
          else
          {
            speedMotorA = 1.0f;
            speedMotorB = 1.0f;
          }
        }

        if (webSettings.motorsEnabled)
        {
          // serial.printf("Motors enabled\r\n");
          motorA.setSpeed(speedMotorA);
          motorB.setSpeed(speedMotorB);
        } else
        {
          // serial.printf("Motors disabled\r\n");
          motorA.setBrake(false);
          motorB.setBrake(false);
        }

        PIDLastError = PIDError;
        lastDigitizedSensorsReading = digitizedSensorsReading;

        PIDLastUpdateTime = currentTime;
      }
    } else
    {
      PIDLastUpdateTime = currentTime;
    }
  }
}
#endif
