#if 0
#include "mbed.h"
#include "lib/RWR_Utils/RWR_Utils.hxx"

Motor motorA(DRV_AENBL, DRV_APHASE);
Motor motorB(DRV_BENBL, DRV_BPHASE);

DigitalOut led(LED1);

DigitalOut espCHPD(ESP_CHPD);
DigitalOut espGPIO0(ESP_GPIO0);
DigitalOut espReset(ESP_RESET);
Serial esp(ESP_RX, ESP_TX, WEB_ESP_BAUD);

DigitalOut ctl(QTR_CTL);
AnalogIn qtrPins[SENSORS_BAR_SIZE] = {QTR_3,
  QTR_5,
  QTR_7,
  QTR_9,
  QTR_11,
  QTR_13};
QTR qtr(ctl, qtrPins, 15);

Serial serial(USBTX, USBRX, 115200);

web_settings_t webSettings = {};

int main()
{
    motorA.setBrake(false);
    motorB.setBrake(false);

    espCHPD = 0;
    espReset = 0;
    espGPIO0 = 0;
    led = 0;
    wait(0.5);
    led = 1;

    while(1)
    {
      uint32_t sensorsAverage = 0;
      for (uint32_t i = 0; i < SENSORS_BAR_SIZE; i++)
      {
        uint32_t sensorValue = (uint32_t) qtrPins[i].read_u16();
        serial.printf("Sensor %lu analog value: %lu\r\n", i, sensorValue);
        sensorsAverage += sensorValue;
      }
      sensorsAverage /= SENSORS_BAR_SIZE;
      serial.printf("Sensors average analog value: %lu\r\n", sensorsAverage);

      uint32_t sensors = qtr.readSensorsAsDigital();
      serial.printf("Digitized sensor values: ");
      for (uint32_t mask = (1 << 31); mask > 0; mask >>= 1)
      {
        serial.printf("%lu", ((sensors & mask) != 0));
      }
      serial.printf("\r\n");
      float floatSensors = qtr.readSensorsAsFloat();
      // workaround for printf without float support
      serial.printf("Float sensor values multiplied by 1000: %i\r\n", (int)(floatSensors * 1000.0f));
      serial.printf("\r\n\r\n");

      wait_ms(500);
    }
}
#endif
