#if 1
#include "mbed.h"
#include "lib/RWR_Utils/RWR_Utils.hxx"

DeepSleepLock lock;

Motor motorA(DRV_AENBL, DRV_APHASE); // left motor
Motor motorB(DRV_BENBL, DRV_BPHASE); // right motor

DigitalOut led(LED1);

DigitalOut espCHPD(ESP_CHPD);
DigitalOut espGPIO0(ESP_GPIO0);
DigitalOut espReset(ESP_RESET);
Serial esp(ESP_RX, ESP_TX, WEB_ESP_BAUD);

DigitalOut ctl(QTR_CTL);
AnalogIn qtrPins[SENSORS_BAR_SIZE] = {QTR_3,
  QTR_5,
  QTR_7,
  QTR_9,
  QTR_11,
  QTR_13};
QTR qtr(ctl, qtrPins, 15);

Serial serial(USBTX, USBRX, 115200);

web_settings_t webSettings = {
  WEB_MOTORS_ENABLED_DEFAULT,
  (int32_t) (PID_DEFAULT_KP * 1000),
  (int32_t) (PID_DEFAULT_KI * 1000),
  (int32_t) (PID_DEFAULT_KD * 1000),
};

int32_t PIDLastUpdateTime = 0;
Timer PIDUpdateTimer;

int main()
{
  uint32_t digitizedSensorsReading;

  motorA.setBrake(false);
  motorB.setBrake(false);

  espCHPD = 0;
  espReset = 0;
  espGPIO0 = 0;
  led = 0;

  wait(0.5);

  led = 1;

  esp.attach(&ESPReceiveIRQ, Serial::RxIrq);

  #ifdef ENABLE_PASSTHROUGH
    serial.attach(&USBReceiveIRQ, Serial::RxIrq);
  #endif

  PIDUpdateTimer.start();

  while(1)
  {
    ESPRunStateMachine();

    int32_t currentTime = PIDUpdateTimer.read_us();

    // handle timer overflow
    if (currentTime > PIDLastUpdateTime)
    {
      // run this periodically based on timer reading
      // with default settings, this will run 1000 times a second
      if (currentTime - PIDLastUpdateTime >= PID_UPDATE_PERIOD_US)
      {
        digitizedSensorsReading = qtr.readSensorsAsDigital();

        // all sensors on reflective surface, no line
        if (digitizedSensorsReading == 0U)
        {
          // >>>>>>>>>>>>>>>>>>> TODO: add your code here <<<<<<<<<<<<<<<<<<<<<<<<<<
          // decide what to do in case the robot sees no line
        } else
        // all sensors on black surface or lifted off the playfield
        if (digitizedSensorsReading == SENSORS_ALL_ONES)
        {
          // >>>>>>>>>>>>>>>>>>> TODO: add your code here <<<<<<<<<<<<<<<<<<<<<<<<<<
          // decide what to do in case the robot is lifted off the playfiled
          // hint: probably the best thing to do here is to stop the motors
        } else
        // line detected
        {
          // >>>>>>>>>>>>>>>>>>> TODO: add your code here <<<<<<<<<<<<<<<<<<<<<<<<<<
          // implement your control algorithm here
          // hint: look online for simple PID implementations for Arduino, C or C++
          // the feedback input of the algorithm is the position of the line given by this call:
          // qtr.digitizedSensorsToFloat(digitizedSensorsReading);
          // this returns line position as a float between -1.0 (left) and 1.0 (right)
        }

        if (webSettings.motorsEnabled)
        {
          // >>>>>>>>>>>>>>>>>>> TODO: add your code here <<<<<<<<<<<<<<<<<<<<<<<<<<
          // hint: set motor speeds here
          // use motor speeds calculated above by your control algorithm
        } else
        {
          // stop motors, but do not apply brakes
          motorA.setBrake(false);
          motorB.setBrake(false);
        }

        PIDLastUpdateTime = currentTime;
      }
    } else
    {
      PIDLastUpdateTime = currentTime;
    }
  }
}
#endif
