#include "mbed.h"
#include "nRF24L01P.h"
#include <chrono>

//Init Pins
SPI spi(D11, D12, D13);
DigitalOut cs(D10, 1);
nRF24L01P my_nrf24l01p(D11, D12, D13, D8, D9, D7);    // mosi, miso, sck, csn, ce, irq

#define TRANSFER_SIZE   2
char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
int txDataCnt = 0;
int rxDataCnt = 0;

bool transmitter = true;

bool ackknowledged = true;

void init() {

    // Display the (default) setup of the nRF24L01+ chip
    printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    setLed(led);
}


void readNRF() {
// If we've received anything in the nRF24L01+...
    if ( my_nrf24l01p.readable() ) {

        // ...read the data into the receive buffer
        rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
        
        if (rxData[0] == 0) {
            printf("Received request for %d\n\r", rxData[1]);
            txData[0] = 1;
            txData[1] = rxData[1];
            led = rxData[1];
            setLed(led);
            my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE );
            printf("Sent ack for %d\n\r", rxData[1]);
        }
        if (rxData[0] == 1) {
            printf("Received acknowledgment for %d\n\r", rxData[1]);
            ackknowledged = true;
            setLed(rxData[1]);    
        }
    }    
}

void sendNumber(int number) {
    
    // ...add it to the transmit buffer
    txData[0] = 0;
    txData[1] = led;
    
    ackknowledged = false;
    
    while (!ackknowledged) {
        printf("Sending request for led: %d\n\r", led);
        // Send the transmitbuffer via the nRF24L01+
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE );
        readNRF();
        wait(0.5);
    }
}

void startTest() {
    std::chrono::time_point<std::chrono::system_clock> start, end;
    // start timer
    start = std::chrono::system_clock::now();
    // loop { send getal
    // wacht op ack }
    // send FIN
    // wacht op FIN ACK
    // stop timer
    end = std::chrono::system_clock::now();
    std::chrono::duration<double> duration = end - start;
    std::cout << "Test duration: " << duration.count() << " seconds\n";
}

int main() {    
    init();
    
    if (transmitter) {
        startTest();
    } else {
        //listen ofzo
    }
    
    while (true) {
        readButton();
        readNRF();
        wait(0.1);
    }
}