#include "mbed.h"
#include "nRF24L01P.h"

//Init Pins
SPI spi(D11, D12, D13);
DigitalOut cs(D10, 1);
nRF24L01P my_nrf24l01p(D11, D12, D13, D8, D9, D7);    // mosi, miso, sck, csn, ce, irq

    
#define TRANSFER_SIZE   2
char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
int txDataCnt = 0;
int rxDataCnt = 0;

int led = 0;
bool ackknowledged = true;

void setLed(int i) {
    printf("Setting led to %d", i);
    cs = 0;
    spi.write(0x46);
    spi.write(0x09);
    
    int mask = 1;
    int writeValue = 255;
    writeValue ^= mask << i;
    spi.write(writeValue);
    cs = 1;
}
    
void init() {
    cs = 0;
 
    spi.write(0x46); // Select IODIR
    spi.write(0x00); // 0000 = Set all to output
    spi.write(0x00);
  
    // Deselect the device
    cs = 1;

    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    setLed(led);
}


void readNRF() {
// If we've received anything in the nRF24L01+...
    if ( my_nrf24l01p.readable() ) {

        // ...read the data into the receive buffer
        rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
        
        if (rxData[0] == 0) {
            printf("Received request for %d", rxData[1]);
            txData[0] = 1;
            txData[1] = rxData[1];
            my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE );
        }
        if (rxData[0] == 1) {
            printf("Received acknowledgment for %d", rxData[1]);
            ackknowledged = true;
            setLed(rxData[1]);    
        }
    }    
}

void sendNumber(int number) {
    
    // ...add it to the transmit buffer
    txData[0] = 0;
    txData[1] = number;
    
    ackknowledged = false;
    
    while (!ackknowledged) {
        printf("Sending led: %d\n\r", number);
        // Send the transmitbuffer via the nRF24L01+
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE );
        readNRF();
        wait(0.5);
    }
}

void readButton() {
    cs = 0;
    spi.write(0x47);
    spi.write(0x09);
    int misoOutput = spi.write(0x00);
    cs = 1;
    misoOutput = misoOutput & 192;
        
    //printf("output miso: %d \n\r", misoOutput);
    if (misoOutput == 128) { // S1 pressed
        led = (led + 1) % 6;
        sendNumber(led);
    } else if (misoOutput == 64) { // S2 pressed
        led = (led + 5) % 6;
        sendNumber(led);
    }
}

int main() {    
    cs = 1;
    init();
    
    while (true) {
        readButton();
        readNRF();
        wait(0.1);
    }
}