#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(D11, D12, D13, D8, D9, D7);

bool receiver = false;

#define TRANSFER_SIZE   2

void setDefaults() {
    my_nrf24l01p.setRfFrequency(DEFAULT_NRF24L01P_RF_FREQUENCY);
    my_nrf24l01p.setRfOutputPower(DEFAULT_NRF24L01P_TX_PWR);
    my_nrf24l01p.setAirDataRate(DEFAULT_NRF24L01P_DATARATE);
}

void setFrequency(int frequency) {
    my_nrf24l01p.setRfFrequency(frequency);
}

void setPower(int power) {
    my_nrf24l01p.setRfOutputPower(power);
}

void setDataReet(int datareet) {
    my_nrf24l01p.setAirDataRate(datareet);
}

void printSettings() {
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
    pc.printf( "(transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
}

void quitTest() {
    
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int rxDataCnt = 0;
    txData[0] = 'q';
    txData[1] = 'q';
    
    bool acked = false;
    
    while (!acked) {
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, 2 );
        if ( my_nrf24l01p.readable() ) {
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            for (int i = 0; i < rxDataCnt; i++) {
                char c = rxData[i];
                if (c == 'q') {
                    acked = true;
                }    
            }
        }
        wait(0.1);
    }
}

void senderTest(int frequency, int outputPower, int dataRate, int delay, int count) {
    my_nrf24l01p.setRfFrequency(frequency);
    my_nrf24l01p.setRfOutputPower(outputPower);
    my_nrf24l01p.setAirDataRate(dataRate);
    my_nrf24l01p.enableAutoRetransmit(delay, count);
    
    char txData[TRANSFER_SIZE];
    int txDataCnt = 0;
    
    pc.printf("--- SETTINGS: ---\n\r");
    printSettings();
    pc.printf("-----------------\n\r");
    
    for (int i = 0; i < 1000; i++) {
        char c = i % 100;
        txData[txDataCnt++] = c;
        if (txDataCnt >= sizeof(txData)) {
            //pc.printf("Printing txData: %d %d\n\r", txData[0], txData[1]);
            // Send the transmitbuffer via the nRF24L01+
            my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
            txDataCnt = 0;
        }
    }
    
    quitTest();

    pc.printf("Finished run!\n\r\n\r");
}

int main() {

// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.

    char rxData[TRANSFER_SIZE]; 
    
    my_nrf24l01p.setRfFrequency(2400);
    
    printSettings();
     
    my_nrf24l01p.powerUp();
    
    my_nrf24l01p.enableAutoAcknowledge(NRF24L01P_PIPE_P0);
//    my_nrf24l01p.enableAutoRetransmit(100000, 10);
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    int data[1000];
    if (receiver) {
        int rxPacketCnt = 0;
        int rxDataCnt = 0;
        bool reading = true;
        pc.printf(">> Receiving Modus << \n\r");
        while (reading) {
            if ( my_nrf24l01p.readable() ) {
                rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
                for (int i = 0; i < rxDataCnt; i++) {
                    char c = rxData[i];
                    if (c == 'q') {
                        if (rxPacketCnt != 0) {
                            char txData[TRANSFER_SIZE];
                            txData[0] = 'q';
                            txData[1] = 'q';
                            pc.printf("\n\r-----------\n\r");
                            pc.printf("DONE!: length = %d \r\n", rxPacketCnt);
                            pc.printf("-----------\n\r");
                            rxPacketCnt = 0;
                            
                            my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, 2);
                        }
                    } else {
                        data[rxPacketCnt++] = c;
                    }
                }
                rxDataCnt = 0;
            }
        }             
    }
    else { // Transmit mode
       pc.printf(">> Sending Modus << \n\r");
       // Frequency test
       //pc.printf("FREQUENCY TEST \n\r");
       //senderTest(2400, NRF24L01P_TX_PWR_ZERO_DB, NRF24L01P_DATARATE_1_MBPS, false);
       //senderTest(2463, NRF24L01P_TX_PWR_ZERO_DB, NRF24L01P_DATARATE_1_MBPS, false);
       //senderTest(2525, NRF24L01P_TX_PWR_ZERO_DB, NRF24L01P_DATARATE_1_MBPS, false);
//       // Power (dBm) test
       pc.printf("OUTPUT POWER TEST");
//       senderTest(2402, NRF24L01P_TX_PWR_ZERO_DB, NRF24L01P_DATARATE_1_MBPS, 0, 0);
//       senderTest(2402, NRF24L01P_TX_PWR_MINUS_6_DB, NRF24L01P_DATARATE_1_MBPS, 0, 0);
//       senderTest(2402, NRF24L01P_TX_PWR_MINUS_12_DB, NRF24L01P_DATARATE_1_MBPS, 0 ,0);
//       senderTest(2402, NRF24L01P_TX_PWR_MINUS_18_DB, NRF24L01P_DATARATE_1_MBPS, 0, 0);
//       // Data rate test
//       pc.printf("DATARATE TEST");
//       senderTest(2402, NRF24L01P_TX_PWR_ZERO_DB, NRF24L01P_DATARATE_250_KBPS, false);
//       senderTest(2402, NRF24L01P_TX_PWR_ZERO_DB, NRF24L01P_DATARATE_1_MBPS, false);
//       senderTest(2402, NRF24L01P_TX_PWR_ZERO_DB, NRF24L01P_DATARATE_2_MBPS, false);
        pc.printf("ART DELAY TEST");
        senderTest(2402, NRF24L01P_TX_PWR_MINUS_12_DB, NRF24L01P_DATARATE_1_MBPS, 0, 8);
//       senderTest(2402, NRF24L01P_TX_PWR_MINUS_18_DB, NRF24L01P_DATARATE_1_MBPS, 8, 8);
//       senderTest(2402, NRF24L01P_TX_PWR_MINUS_18_DB, NRF24L01P_DATARATE_1_MBPS, 15, 8);
    }
}