#include "mbed.h"
#include "EthernetInterface.h"
#include "SocketAddress.h"
#include "UDPSocket.h"
#include "lwip/ip.h"
#include "lwip/api.h"
#include <string.h>

const char* ECHO_SERVER_ADDRESS = "192.168.1.148";    // addresse du PC home "192.168.1.2" sergio "169.254.61.104" or "129.194.185.33" or "192.168.137.1" liotard "10.136.134.73"
const int ECHO_SERVER_PORT = 1036;
//const int BROADCAST_PORT = 58083;

Timer t;
Timer t1;
Timer t2;
Timer t3;
DigitalOut PSU_DEAD(D8); // Kill PSU
DigitalOut PSU_OFF(D9); // Power On PSU

volatile long int count = 0;
int tours = 5;
double rpm[18] = {0.0};
bool readRpm = 0;
bool readAllRpm = 0;
bool skipRead = 0;

// PWM PINS
PwmOut rearFans[9]={PB_5, PB_15, PC_8,  PB_10, PB_8, PE_10, PE_14, PE_6, PB_1};
PwmOut frontFans[9]= {PB_3, PB_9, PC_9, PB_11, PC_6, PD_13, PE_12, PE_5, PE_9};

// F00 PINS
PinName counterFront[9]={PA_3,PC_3,PF_5,PF_7,PD_7,PE_4,PC_2,PB_2,PE_3};
PinName counterRear[9]={PC_0,PF_3,PF_10,PF_9,PE_0,PG_0,PF_8,PD_11,PF_4};

// LEDS
DigitalOut greenLed(LED1);
DigitalOut bleuLed(LED2);
DigitalOut redLed(LED3);

// ARGUMENTS TO BE RECEIVED BY ETHERNET
char arg1_str[2]  = {0};
char arg2_str[10] = {0};
char arg3_str[4]  = {0};

int arg1 = 0;
int arg3 = 0;
int fan[10] = {0};
int fan_nb = 0;
float pwm_f = 0.0;

int arg1_len = 0;
int arg2_len = 0;
int arg3_len = 0;

void splitString(char stringToSplit[]);
int transString(char stringToTrans[]);
void countFunction();


int main(int argc, char *argv[]) {

    // Turn off the PSU (Standby Mode)
    PSU_OFF = true;
    
    // Set PWM timer frequency and set PWM to 0.0%
    for(int i = 0; i < 9; i++){
        frontFans[i].period_ms(10);
        rearFans[i].period_ms(10);
        frontFans[i].write(0.0);
        rearFans[i].write(0.0);
    }

    // Initialize ethernet interface and UDP socket
    EthernetInterface eth;                          
    UDPSocket sock;                                
    SocketAddress echo_server; 
    
    // Connect to the ethernet port
    eth.connect();
    sock.open(&eth);
    
    // Get IP address of the board
    const char *local_ip = eth.get_ip_address();
    printf("\nClient IP Address is %s \n", local_ip);
    
    // Get the MAC address of the board
    const char *local_mac = eth.get_mac_address();
    printf("Port num is %d \n", ECHO_SERVER_PORT);
    
    echo_server.set_ip_address(ECHO_SERVER_ADDRESS);
    echo_server.set_port(ECHO_SERVER_PORT);
    
    greenLed = 1;
    wait(1);
    greenLed = 0;
    wait(1);
    
    bool ack = 0;
    
    while(ack == 0){
        char out_buffer[18];
        snprintf(out_buffer, sizeof(out_buffer), "%s", eth.get_mac_address());
        //sprintf(out_buffer, "%s", eth.get_mac_address());
        sock.sendto(echo_server, out_buffer, sizeof(out_buffer));
        
        printf("%s\n", out_buffer);
        
        sock.set_timeout(1000);
        
        char in_buffer[256];
        int n = sock.recvfrom(&echo_server, in_buffer, sizeof(in_buffer));
        in_buffer[n] = '\0';
        
        printf("%s\n", in_buffer);
        
        int ack_message = transString(in_buffer);
        
        if(ack_message == 1){
            ack = 1;
            sock.set_timeout(-1);
            //PSU_OFF = false;            // turns on the PSU if init is complet
        }
    }
    

    while(1){
        char out_buffer[] = "";
        printf("\n-----------------------------------\n");
        sock.sendto(echo_server, out_buffer, sizeof(out_buffer));
        
        
        char in_buffer[256];
        int n = sock.recvfrom(&echo_server, in_buffer, sizeof(in_buffer));    
        
        // Add \0 as end of line character to the input message
        in_buffer[n] = '\0';
        
        // Split the input message and save value in FR_str, fan_str and pwm_str
        splitString(in_buffer);
        
        // Print the order that was received
        printf("ORDER RECEIVED : %s, %s, %s\n", arg1_str, arg2_str, arg3_str);

        switch(arg1){
            
            // Set the PWM of a front fan in particular
            case 0:
                if(fan[0] == 0){
                    for(int i = 0; i < 9; i++){
                        frontFans[i].write(pwm_f);
                    }
                }
                else{
                    for(int i = 0; i < arg2_len; i++){
                        frontFans[fan[i] - 1].write(pwm_f);
                    }
                }
            break;
            
            // Set the PWM of a rear fan in particular
            case 1:        
            if(fan[0] == 0){
                for(int i = 0; i < 9; i++){
                    rearFans[i].write(pwm_f);
                }
            }
            else{
                for(int i = 0; i < arg2_len; i++){
                    rearFans[fan[i] - 1].write(pwm_f);
                }
            }
            break;
            
            case 2:         // both fans
            if(fan[0] == 0){
                for(int i = 0; i < 9; i++){
                    frontFans[i].write(pwm_f);
                    rearFans[i].write(pwm_f);
                }
            }
            else{
                for(int i = 0; i < arg2_len; i++){
                    frontFans[fan[i] - 1].write(pwm_f);
                    rearFans[fan[i] - 1].write(pwm_f);
                }
            }
            break;
            
            case 3:         // turns off PSU
            PSU_OFF = true;
            //char out_bufferF[] = "PSU OFF";
            //sock.sendto(echo_server, out_bufferF, sizeof(out_bufferF));
            break;
            
            case 4:         // turns on PSU
            PSU_OFF = false;
            //char out_bufferN[] = "PSU ON";
            //sock.sendto(echo_server, out_bufferN, sizeof(out_bufferN));
            break;
            
            case 5:         // kills the PSU
            PSU_DEAD = true;
            //char out_bufferK[] = "PSU KILLED";
            //sock.sendto(echo_server, out_bufferK, sizeof(out_bufferK));
            break;
            
            case 6:         // revives the PSU
            PSU_DEAD = false;
            //char out_bufferR[] = "PSU REVIVED";
            //sock.sendto(echo_server, out_bufferR, sizeof(out_bufferR));
            break;
            
            // Display F00 for front fans
            case 20:{
                for (int i =0;i<9;i++){
                    InterruptIn rpmIn1(counterFront[i]);
                    t1.reset();
                    count = 0;
                    rpmIn1.rise(&countFunction);
                    int c = 0;
                    while(count<=4 && c<1000){
                        c++;
                    }
                    rpmIn1.rise(NULL);
                    double rpm1 = 60*1000.0/(t1.read_ms()/2.0);
                    if (i%3==0)
                        printf("\n");
                    printf(" %lf ", rpm1);
                }
                printf("\n");
            }
            break;
            
            // Display F00 for rear fans
            case 21:{
                for (int i =0;i<9;i++){
                    InterruptIn rpmIn1(counterRear[i]);
                    t1.reset();
                    count = 0;
                    rpmIn1.rise(&countFunction);
                    int c = 0;
                    while(count<=4 && c<1000){
                        c++;
                    }
                    rpmIn1.rise(NULL);
                    double rpm1 = 60*1000.0/(t1.read_ms()/2.0);
                    if (i%3==0)
                        printf("\n");
                    printf(" %lf ", rpm1);
                }
                printf("\n");
                
            }
            break;
            
            // Set a diffenrent PWM value to all fans from 8% to 32% for test purpose
            case 30:{
                int pwm_17 = 8;
                for(int i = 0; i < 9; i++){
                    float p=(pwm_17+2*i)/100.0;
                    frontFans[i].write(p);
                    rearFans[i].write(p);
                }
            }
            break;
            
            case 99:{
                
            }
            break;
            
            default:
                for(int i = 0; i < 9; i++){
                    frontFans[i].write(0.0);
                    rearFans[i].write(0.0);
                }
        }
        for(int i = 0; i <= 2; i++){
            arg1_str[i] = '\0';       // "resets" the arg1_str
        }      
        for(int i = 0; i <= 4; i++){
            arg3_str[i] = '\0';      // "resets" the arg3_str
        }
    }
}

void splitString(char stringToSplit[]){
    char *comma_1 = strchr(stringToSplit, ',') + 1;
    char *comma_2 = strchr(comma_1, ',') + 1;
    char *comma_3 = strchr(comma_3, '\0');
    
    arg1_len = comma_1 - stringToSplit - 1;
    arg2_len = comma_2 - comma_1 - 1;
    arg3_len = comma_3 - comma_2;
    
    // Argument 1
    strncpy(arg1_str, stringToSplit, arg1_len);
    arg1 = strtol(arg1_str, NULL, 10);
    
    // Argument 2
    strncpy(arg2_str, comma_1, arg2_len);
    for(int i = 0; i < arg2_len; i++){
        fan[i] = arg2_str[i] - '0';
    }
    
    // Save the last number of arg2 into fan_nb as int
    for(int i = 0; i<arg2_len; i++){
        fan_nb = arg2_str[i] - '0';
    } 

    // Argument 3
    strncpy(arg3_str, comma_2, arg3_len);
    double arg3 = strtod(arg3_str, NULL);
    pwm_f = arg3/100.0;
}

int transString(char stringToTrans[]){
    char in_str[2] = {0};
    strncpy(in_str, stringToTrans,1);
    return atoi(in_str);
}

void countFunction(){
    // Start timer when the first rising edge is reached
    if (count == 0)
        t1.start(); 
    
    // Stop timer when the fourth rising edge is reached (2 rotation)
    if (count == 4)
        t1.stop(); 
        
    count++;
}

