#ifndef CONTROLLER
#define CONTROLLER

#include <functional>
#include <math.h>
#include <mbed.h>
#include <vector>

#include "Eigen/Dense.h"
#include "PM2_Libary.h" // TODO: figure out include paths

#include "IRSensor.h"
#include "PinNames.h"

// Abstract class for generic controllers.

class Controller {

public:
  Controller(); // initialize controller
  void Update();
  float Period() const;
  /* USER BUTTON FUNCTIONS */
  bool GetTurnedOn();

private:
  /* TIMING */
  const float update_period = 1e-3f;
  Ticker ticker; // calls a function every period
};

#endif // CONTROLLER