#include "controller.h"
#include <cstdio>

static void
UserButtonPressed(); // DEFINE STATIC functions TO BE USED BY THE CONTROLLER
static void
UserButtonReleased(); // THEY HAVE TO BE STATIC TO SUPPORT C CALLBACK
void UpdateTaskTrigger();
bool robot_turned_on = false;

// user button on nucleo board
Timer user_button_timer; // create Timer object which we use to check if user
                         // button was pressed for a certain time (robust
                         // against signal bouncing)
InterruptIn user_button(
    PC_13); // create InterruptIn interface object to evaluate user button
            // falling and rising edge (no blocking code in ISR)

EventFlags event_flags;
const uint32_t main_task_flag = 1;

// use this to initialize all controller pins IO
Controller::Controller() {
  // initialize the update function timer
  user_button.fall(&UserButtonPressed);
  user_button.rise(&UserButtonReleased);

  ticker.attach(UpdateTaskTrigger, std::chrono::microseconds(
                                       static_cast<int>(update_period * 1e6)));
}

void Controller::Update() {
  // TIMER. WAIT OR SOMETHING.
  event_flags.wait_any(main_task_flag);
}

float Controller::Period() const { return update_period; }

bool Controller::GetTurnedOn() { return robot_turned_on; }

// STATIC FUNCTIONS
static void UserButtonPressed() {
  user_button_timer.start();
  user_button_timer.reset();
}

static void UserButtonReleased() {
  // read timer and toggle robot_turned_on if the button was pressed longer than
  // the below specified time
  int user_button_elapsed_time_ms =
      std::chrono::duration_cast<std::chrono::milliseconds>(
          user_button_timer.elapsed_time())
          .count();
  user_button_timer.stop();
  if (user_button_elapsed_time_ms > 200) {
    robot_turned_on = !robot_turned_on;
  }
}

void UpdateTaskTrigger() { event_flags.set(main_task_flag); }

// real time os
// cant wait in interrupt servivce routine