//8.3 LCD control with MBED main.

#include "mbed.h"
#include "TextLCD.h"
#include "TimeControl.h"
#include "Alarm.h"
#include <time.h>

Serial pc(USBTX,USBRX);

DigitalIn AlarmAdjust(p9);   // Used to Adjust the Alarm
InterruptIn off(p15);       // Used to turn off the Alarm

DigitalIn timeSW(p10);    // Used to adjust the time
DigitalOut led2(LED2);

int main() 
{
    time_init();            // Initializes clock and alarm times
    off.rise(&turn_off);  // Waits for signal from off switch on remote XBee
    
    while(1)
    {
        timeDisplay(); // Constantly Displays the Time
        if(checkAlarm())  // Checks to see if it is time to sound the alarm and does so if apropriate
        {
            Sound_Alarm();
        }
        
        if(timeSW==1)timeProg();           // Activate using black switch
        if(AlarmAdjust==1) alarmProg();    // Activate using Blue button with switch closed 
    }
}


   
   
   